@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.BotAbortStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property messages A set of messages, each of which provides a message string and its type.
 * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
 * Attributes are documented under message.
 * @property responseCard The response card. Amazon Lex will substitute session attributes and
 * slot values into the response card. For more information, see
 * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html).
 */
public data class BotAbortStatementArgs(
    public val messages: Output<List<BotAbortStatementMessageArgs>>,
    public val responseCard: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.BotAbortStatementArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.BotAbortStatementArgs =
        com.pulumi.aws.lex.inputs.BotAbortStatementArgs.builder()
            .messages(
                messages.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseCard(responseCard?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BotAbortStatementArgs].
 */
@PulumiTagMarker
public class BotAbortStatementArgsBuilder internal constructor() {
    private var messages: Output<List<BotAbortStatementMessageArgs>>? = null

    private var responseCard: Output<String>? = null

    /**
     * @param value A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message.
     */
    @JvmName("ymnvnmkluhjxjytt")
    public suspend fun messages(`value`: Output<List<BotAbortStatementMessageArgs>>) {
        this.messages = value
    }

    @JvmName("nbcjqmwlajoyquif")
    public suspend fun messages(vararg values: Output<BotAbortStatementMessageArgs>) {
        this.messages = Output.all(values.asList())
    }

    /**
     * @param values A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message.
     */
    @JvmName("mvypjyfmhrulussn")
    public suspend fun messages(values: List<Output<BotAbortStatementMessageArgs>>) {
        this.messages = Output.all(values)
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html).
     */
    @JvmName("ukrdncuoueeqmrru")
    public suspend fun responseCard(`value`: Output<String>) {
        this.responseCard = value
    }

    /**
     * @param value A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message.
     */
    @JvmName("xjqajqtctsymaisc")
    public suspend fun messages(`value`: List<BotAbortStatementMessageArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message.
     */
    @JvmName("obnggcjbelnhkciv")
    public suspend
    fun messages(argument: List<suspend BotAbortStatementMessageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BotAbortStatementMessageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message.
     */
    @JvmName("gtlxdwvklxlfkblp")
    public suspend fun messages(
        vararg
        argument: suspend BotAbortStatementMessageArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BotAbortStatementMessageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message.
     */
    @JvmName("gkgtbutfnyhhkrtj")
    public suspend fun messages(argument: suspend BotAbortStatementMessageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BotAbortStatementMessageArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param values A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message.
     */
    @JvmName("jfbelxcpwmsmcpne")
    public suspend fun messages(vararg values: BotAbortStatementMessageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html).
     */
    @JvmName("nxnysgeuiltyiqag")
    public suspend fun responseCard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCard = mapped
    }

    internal fun build(): BotAbortStatementArgs = BotAbortStatementArgs(
        messages = messages ?: throw PulumiNullFieldException("messages"),
        responseCard = responseCard,
    )
}
