@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.BotClarificationPromptArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property maxAttempts The number of times to prompt the user for information.
 * @property messages A set of messages, each of which provides a message string and its type.
 * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
 * Attributes are documented under message.
 * @property responseCard The response card. Amazon Lex will substitute session attributes and
 * slot values into the response card. For more information, see
 * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html).
 */
public data class BotClarificationPromptArgs(
    public val maxAttempts: Output<Int>,
    public val messages: Output<List<BotClarificationPromptMessageArgs>>,
    public val responseCard: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.BotClarificationPromptArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.BotClarificationPromptArgs =
        com.pulumi.aws.lex.inputs.BotClarificationPromptArgs.builder()
            .maxAttempts(maxAttempts.applyValue({ args0 -> args0 }))
            .messages(
                messages.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseCard(responseCard?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BotClarificationPromptArgs].
 */
@PulumiTagMarker
public class BotClarificationPromptArgsBuilder internal constructor() {
    private var maxAttempts: Output<Int>? = null

    private var messages: Output<List<BotClarificationPromptMessageArgs>>? = null

    private var responseCard: Output<String>? = null

    /**
     * @param value The number of times to prompt the user for information.
     */
    @JvmName("nygtftomvdmntkiy")
    public suspend fun maxAttempts(`value`: Output<Int>) {
        this.maxAttempts = value
    }

    /**
     * @param value A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message.
     */
    @JvmName("qqdfreyupnwtteuv")
    public suspend fun messages(`value`: Output<List<BotClarificationPromptMessageArgs>>) {
        this.messages = value
    }

    @JvmName("kidufvghfndyigku")
    public suspend fun messages(vararg values: Output<BotClarificationPromptMessageArgs>) {
        this.messages = Output.all(values.asList())
    }

    /**
     * @param values A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message.
     */
    @JvmName("nkkdwtcrwhnmcnsy")
    public suspend fun messages(values: List<Output<BotClarificationPromptMessageArgs>>) {
        this.messages = Output.all(values)
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html).
     */
    @JvmName("fjexxuaswrvqaamu")
    public suspend fun responseCard(`value`: Output<String>) {
        this.responseCard = value
    }

    /**
     * @param value The number of times to prompt the user for information.
     */
    @JvmName("bhcdbbesrlvegttr")
    public suspend fun maxAttempts(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxAttempts = mapped
    }

    /**
     * @param value A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message.
     */
    @JvmName("srgqvcmhmbtnsjmr")
    public suspend fun messages(`value`: List<BotClarificationPromptMessageArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message.
     */
    @JvmName("dlehmxftstsdodra")
    public suspend
    fun messages(argument: List<suspend BotClarificationPromptMessageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BotClarificationPromptMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message.
     */
    @JvmName("jmnbvifspqgcpgqc")
    public suspend fun messages(
        vararg
        argument: suspend BotClarificationPromptMessageArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BotClarificationPromptMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message.
     */
    @JvmName("chvmwagxgwtkwuul")
    public suspend
    fun messages(argument: suspend BotClarificationPromptMessageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BotClarificationPromptMessageArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param values A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message.
     */
    @JvmName("pclljkmlejsmueji")
    public suspend fun messages(vararg values: BotClarificationPromptMessageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html).
     */
    @JvmName("fqyppiwgnrahntuh")
    public suspend fun responseCard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCard = mapped
    }

    internal fun build(): BotClarificationPromptArgs = BotClarificationPromptArgs(
        maxAttempts = maxAttempts ?: throw PulumiNullFieldException("maxAttempts"),
        messages = messages ?: throw PulumiNullFieldException("messages"),
        responseCard = responseCard,
    )
}
