@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.GetBotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBot.
 * @property name Name of the bot. The name is case sensitive.
 * @property version Version or alias of the bot.
 */
public data class GetBotPlainArgs(
    public val name: String,
    public val version: String? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.GetBotPlainArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.GetBotPlainArgs =
        com.pulumi.aws.lex.inputs.GetBotPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .version(version?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBotPlainArgs].
 */
@PulumiTagMarker
public class GetBotPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var version: String? = null

    /**
     * @param value Name of the bot. The name is case sensitive.
     */
    @JvmName("krlntikhbtsccgcr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Version or alias of the bot.
     */
    @JvmName("fnowaoklghsijiga")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetBotPlainArgs = GetBotPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        version = version,
    )
}
