@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.GetSlotTypePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSlotType.
 * @property name Name of the slot type. The name is case sensitive.
 * @property version Version of the slot type.
 */
public data class GetSlotTypePlainArgs(
    public val name: String,
    public val version: String? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.GetSlotTypePlainArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.GetSlotTypePlainArgs =
        com.pulumi.aws.lex.inputs.GetSlotTypePlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .version(version?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSlotTypePlainArgs].
 */
@PulumiTagMarker
public class GetSlotTypePlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var version: String? = null

    /**
     * @param value Name of the slot type. The name is case sensitive.
     */
    @JvmName("seyyydbmoeqstdie")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Version of the slot type.
     */
    @JvmName("qjuelisvxihsaucf")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetSlotTypePlainArgs = GetSlotTypePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        version = version,
    )
}
