@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.IntentConclusionStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property messages A set of messages, each of which provides a message string and its type.
 * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
 * Attributes are documented under message. Must contain between 1 and 15 messages.
 * @property responseCard The response card. Amazon Lex will substitute session attributes and
 * slot values into the response card. For more information, see
 * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
 */
public data class IntentConclusionStatementArgs(
    public val messages: Output<List<IntentConclusionStatementMessageArgs>>,
    public val responseCard: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.IntentConclusionStatementArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.IntentConclusionStatementArgs =
        com.pulumi.aws.lex.inputs.IntentConclusionStatementArgs.builder()
            .messages(
                messages.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseCard(responseCard?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntentConclusionStatementArgs].
 */
@PulumiTagMarker
public class IntentConclusionStatementArgsBuilder internal constructor() {
    private var messages: Output<List<IntentConclusionStatementMessageArgs>>? = null

    private var responseCard: Output<String>? = null

    /**
     * @param value A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("jvruauoplfjkkuop")
    public suspend fun messages(`value`: Output<List<IntentConclusionStatementMessageArgs>>) {
        this.messages = value
    }

    @JvmName("hibgudupyosllrsb")
    public suspend fun messages(vararg values: Output<IntentConclusionStatementMessageArgs>) {
        this.messages = Output.all(values.asList())
    }

    /**
     * @param values A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("vvccmcvjtedsblgg")
    public suspend fun messages(values: List<Output<IntentConclusionStatementMessageArgs>>) {
        this.messages = Output.all(values)
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
     */
    @JvmName("bpjgphisormdkwqg")
    public suspend fun responseCard(`value`: Output<String>) {
        this.responseCard = value
    }

    /**
     * @param value A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("ronyohhknimevbsh")
    public suspend fun messages(`value`: List<IntentConclusionStatementMessageArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("resvrkvoyywghlep")
    public suspend
    fun messages(argument: List<suspend IntentConclusionStatementMessageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IntentConclusionStatementMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("qhgsbeyvmilkfwcg")
    public suspend fun messages(
        vararg
        argument: suspend IntentConclusionStatementMessageArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IntentConclusionStatementMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("ftpsfcsbvhohvnwg")
    public suspend
    fun messages(argument: suspend IntentConclusionStatementMessageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IntentConclusionStatementMessageArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param values A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("diefhsytfuakebjr")
    public suspend fun messages(vararg values: IntentConclusionStatementMessageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
     */
    @JvmName("vgocpiqstkwgrhso")
    public suspend fun responseCard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCard = mapped
    }

    internal fun build(): IntentConclusionStatementArgs = IntentConclusionStatementArgs(
        messages = messages ?: throw PulumiNullFieldException("messages"),
        responseCard = responseCard,
    )
}
