@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.IntentConclusionStatementMessageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property content The text of the message. Must be less than or equal to 1000 characters in length.
 * @property contentType The content type of the message string.
 * @property groupNumber Identifies the message group that the message belongs to. When a group
 * is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
 */
public data class IntentConclusionStatementMessageArgs(
    public val content: Output<String>,
    public val contentType: Output<String>,
    public val groupNumber: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.IntentConclusionStatementMessageArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.IntentConclusionStatementMessageArgs =
        com.pulumi.aws.lex.inputs.IntentConclusionStatementMessageArgs.builder()
            .content(content.applyValue({ args0 -> args0 }))
            .contentType(contentType.applyValue({ args0 -> args0 }))
            .groupNumber(groupNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntentConclusionStatementMessageArgs].
 */
@PulumiTagMarker
public class IntentConclusionStatementMessageArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var contentType: Output<String>? = null

    private var groupNumber: Output<Int>? = null

    /**
     * @param value The text of the message. Must be less than or equal to 1000 characters in length.
     */
    @JvmName("lixoonnttwefspoi")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The content type of the message string.
     */
    @JvmName("syyvtsjvnycfbqjp")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Identifies the message group that the message belongs to. When a group
     * is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
     */
    @JvmName("jmviunrgmhppkwmu")
    public suspend fun groupNumber(`value`: Output<Int>) {
        this.groupNumber = value
    }

    /**
     * @param value The text of the message. Must be less than or equal to 1000 characters in length.
     */
    @JvmName("oekaklbeujoovhvf")
    public suspend fun content(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The content type of the message string.
     */
    @JvmName("vqrlsengreprrqse")
    public suspend fun contentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Identifies the message group that the message belongs to. When a group
     * is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
     */
    @JvmName("icbglkoqrqsovtxr")
    public suspend fun groupNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupNumber = mapped
    }

    internal fun build(): IntentConclusionStatementMessageArgs = IntentConclusionStatementMessageArgs(
        content = content ?: throw PulumiNullFieldException("content"),
        contentType = contentType ?: throw PulumiNullFieldException("contentType"),
        groupNumber = groupNumber,
    )
}
