@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.IntentConfirmationPromptArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property maxAttempts The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
 * @property messages A set of messages, each of which provides a message string and its type.
 * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
 * Attributes are documented under message. Must contain between 1 and 15 messages.
 * @property responseCard The response card. Amazon Lex will substitute session attributes and
 * slot values into the response card. For more information, see
 * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
 */
public data class IntentConfirmationPromptArgs(
    public val maxAttempts: Output<Int>,
    public val messages: Output<List<IntentConfirmationPromptMessageArgs>>,
    public val responseCard: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.IntentConfirmationPromptArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.IntentConfirmationPromptArgs =
        com.pulumi.aws.lex.inputs.IntentConfirmationPromptArgs.builder()
            .maxAttempts(maxAttempts.applyValue({ args0 -> args0 }))
            .messages(
                messages.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseCard(responseCard?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntentConfirmationPromptArgs].
 */
@PulumiTagMarker
public class IntentConfirmationPromptArgsBuilder internal constructor() {
    private var maxAttempts: Output<Int>? = null

    private var messages: Output<List<IntentConfirmationPromptMessageArgs>>? = null

    private var responseCard: Output<String>? = null

    /**
     * @param value The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
     */
    @JvmName("kyajkbqiryhjthvj")
    public suspend fun maxAttempts(`value`: Output<Int>) {
        this.maxAttempts = value
    }

    /**
     * @param value A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("qnwlwjpkfnrdodaa")
    public suspend fun messages(`value`: Output<List<IntentConfirmationPromptMessageArgs>>) {
        this.messages = value
    }

    @JvmName("piumdssemsijlwim")
    public suspend fun messages(vararg values: Output<IntentConfirmationPromptMessageArgs>) {
        this.messages = Output.all(values.asList())
    }

    /**
     * @param values A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("fpimhtcihkqtpewd")
    public suspend fun messages(values: List<Output<IntentConfirmationPromptMessageArgs>>) {
        this.messages = Output.all(values)
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
     */
    @JvmName("hnmlprkfkhmonthe")
    public suspend fun responseCard(`value`: Output<String>) {
        this.responseCard = value
    }

    /**
     * @param value The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
     */
    @JvmName("cifrldubjgaexwft")
    public suspend fun maxAttempts(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxAttempts = mapped
    }

    /**
     * @param value A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("wsmkkyxjfrcbwclu")
    public suspend fun messages(`value`: List<IntentConfirmationPromptMessageArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("dtwenxtmdgmkclew")
    public suspend
    fun messages(argument: List<suspend IntentConfirmationPromptMessageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IntentConfirmationPromptMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("dcevewnihupwaunm")
    public suspend fun messages(
        vararg
        argument: suspend IntentConfirmationPromptMessageArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IntentConfirmationPromptMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("plqdqejyjbtjljct")
    public suspend
    fun messages(argument: suspend IntentConfirmationPromptMessageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IntentConfirmationPromptMessageArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param values A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("wnvbkingnrmuddpr")
    public suspend fun messages(vararg values: IntentConfirmationPromptMessageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
     */
    @JvmName("ulwophsmpacvnqho")
    public suspend fun responseCard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCard = mapped
    }

    internal fun build(): IntentConfirmationPromptArgs = IntentConfirmationPromptArgs(
        maxAttempts = maxAttempts ?: throw PulumiNullFieldException("maxAttempts"),
        messages = messages ?: throw PulumiNullFieldException("messages"),
        responseCard = responseCard,
    )
}
