@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.IntentFollowUpPromptArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property prompt Prompts for information from the user. Attributes are documented under prompt.
 * @property rejectionStatement If the user answers "no" to the question defined in the prompt field,
 * Amazon Lex responds with this statement to acknowledge that the intent was canceled. Attributes are
 * documented below under statement.
 */
public data class IntentFollowUpPromptArgs(
    public val prompt: Output<IntentFollowUpPromptPromptArgs>,
    public val rejectionStatement: Output<IntentFollowUpPromptRejectionStatementArgs>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.IntentFollowUpPromptArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.IntentFollowUpPromptArgs =
        com.pulumi.aws.lex.inputs.IntentFollowUpPromptArgs.builder()
            .prompt(prompt.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rejectionStatement(
                rejectionStatement.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [IntentFollowUpPromptArgs].
 */
@PulumiTagMarker
public class IntentFollowUpPromptArgsBuilder internal constructor() {
    private var prompt: Output<IntentFollowUpPromptPromptArgs>? = null

    private var rejectionStatement: Output<IntentFollowUpPromptRejectionStatementArgs>? = null

    /**
     * @param value Prompts for information from the user. Attributes are documented under prompt.
     */
    @JvmName("ylbftwdlhafkkoff")
    public suspend fun prompt(`value`: Output<IntentFollowUpPromptPromptArgs>) {
        this.prompt = value
    }

    /**
     * @param value If the user answers "no" to the question defined in the prompt field,
     * Amazon Lex responds with this statement to acknowledge that the intent was canceled. Attributes are
     * documented below under statement.
     */
    @JvmName("xcgyljvlqtbuggyi")
    public suspend
    fun rejectionStatement(`value`: Output<IntentFollowUpPromptRejectionStatementArgs>) {
        this.rejectionStatement = value
    }

    /**
     * @param value Prompts for information from the user. Attributes are documented under prompt.
     */
    @JvmName("pjnitsnsbtqiurcf")
    public suspend fun prompt(`value`: IntentFollowUpPromptPromptArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prompt = mapped
    }

    /**
     * @param argument Prompts for information from the user. Attributes are documented under prompt.
     */
    @JvmName("jsbyoyrlfvoyxgtu")
    public suspend fun prompt(argument: suspend IntentFollowUpPromptPromptArgsBuilder.() -> Unit) {
        val toBeMapped = IntentFollowUpPromptPromptArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.prompt = mapped
    }

    /**
     * @param value If the user answers "no" to the question defined in the prompt field,
     * Amazon Lex responds with this statement to acknowledge that the intent was canceled. Attributes are
     * documented below under statement.
     */
    @JvmName("jlbqrdihtlcfljlm")
    public suspend fun rejectionStatement(`value`: IntentFollowUpPromptRejectionStatementArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rejectionStatement = mapped
    }

    /**
     * @param argument If the user answers "no" to the question defined in the prompt field,
     * Amazon Lex responds with this statement to acknowledge that the intent was canceled. Attributes are
     * documented below under statement.
     */
    @JvmName("bccctabkcuiowffw")
    public suspend
    fun rejectionStatement(argument: suspend IntentFollowUpPromptRejectionStatementArgsBuilder.() -> Unit) {
        val toBeMapped = IntentFollowUpPromptRejectionStatementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rejectionStatement = mapped
    }

    internal fun build(): IntentFollowUpPromptArgs = IntentFollowUpPromptArgs(
        prompt = prompt ?: throw PulumiNullFieldException("prompt"),
        rejectionStatement = rejectionStatement ?: throw PulumiNullFieldException("rejectionStatement"),
    )
}
