@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.IntentFollowUpPromptRejectionStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property messages A set of messages, each of which provides a message string and its type.
 * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
 * Attributes are documented under message. Must contain between 1 and 15 messages.
 * @property responseCard The response card. Amazon Lex will substitute session attributes and
 * slot values into the response card. For more information, see
 * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
 */
public data class IntentFollowUpPromptRejectionStatementArgs(
    public val messages: Output<List<IntentFollowUpPromptRejectionStatementMessageArgs>>,
    public val responseCard: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.IntentFollowUpPromptRejectionStatementArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.IntentFollowUpPromptRejectionStatementArgs =
        com.pulumi.aws.lex.inputs.IntentFollowUpPromptRejectionStatementArgs.builder()
            .messages(
                messages.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseCard(responseCard?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntentFollowUpPromptRejectionStatementArgs].
 */
@PulumiTagMarker
public class IntentFollowUpPromptRejectionStatementArgsBuilder internal constructor() {
    private var messages: Output<List<IntentFollowUpPromptRejectionStatementMessageArgs>>? = null

    private var responseCard: Output<String>? = null

    /**
     * @param value A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("unninfgqdvabatua")
    public suspend
    fun messages(`value`: Output<List<IntentFollowUpPromptRejectionStatementMessageArgs>>) {
        this.messages = value
    }

    @JvmName("eysvgsikrgwbavxb")
    public suspend fun messages(
        vararg
        values: Output<IntentFollowUpPromptRejectionStatementMessageArgs>,
    ) {
        this.messages = Output.all(values.asList())
    }

    /**
     * @param values A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("cpfccptneyixeqtq")
    public suspend
    fun messages(values: List<Output<IntentFollowUpPromptRejectionStatementMessageArgs>>) {
        this.messages = Output.all(values)
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
     */
    @JvmName("dyhysuxtoehibqdy")
    public suspend fun responseCard(`value`: Output<String>) {
        this.responseCard = value
    }

    /**
     * @param value A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("fboutwgnyhundpfk")
    public suspend fun messages(`value`: List<IntentFollowUpPromptRejectionStatementMessageArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("ftmsbtmfndmtsqes")
    public suspend
    fun messages(argument: List<suspend IntentFollowUpPromptRejectionStatementMessageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IntentFollowUpPromptRejectionStatementMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("ipmtqkmeqlbkkton")
    public suspend fun messages(
        vararg
        argument: suspend IntentFollowUpPromptRejectionStatementMessageArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IntentFollowUpPromptRejectionStatementMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("jgpmdegfbktuwrbb")
    public suspend
    fun messages(argument: suspend IntentFollowUpPromptRejectionStatementMessageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IntentFollowUpPromptRejectionStatementMessageArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param values A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("foolskgowbuhgsod")
    public suspend fun messages(vararg values: IntentFollowUpPromptRejectionStatementMessageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
     */
    @JvmName("clabatdfvwmpsxoj")
    public suspend fun responseCard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCard = mapped
    }

    internal fun build(): IntentFollowUpPromptRejectionStatementArgs =
        IntentFollowUpPromptRejectionStatementArgs(
            messages = messages ?: throw PulumiNullFieldException("messages"),
            responseCard = responseCard,
        )
}
