@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.IntentFulfillmentActivityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property codeHook A description of the Lambda function that is run to fulfill the intent.
 * Required if type is CodeHook. Attributes are documented under code_hook.
 * @property type How the intent should be fulfilled, either by running a Lambda function or by
 * returning the slot data to the client application. Type can be either `ReturnIntent` or `CodeHook`, as documented [here](https://docs.aws.amazon.com/lex/latest/dg/API_FulfillmentActivity.html).
 */
public data class IntentFulfillmentActivityArgs(
    public val codeHook: Output<IntentFulfillmentActivityCodeHookArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.IntentFulfillmentActivityArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.IntentFulfillmentActivityArgs =
        com.pulumi.aws.lex.inputs.IntentFulfillmentActivityArgs.builder()
            .codeHook(codeHook?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntentFulfillmentActivityArgs].
 */
@PulumiTagMarker
public class IntentFulfillmentActivityArgsBuilder internal constructor() {
    private var codeHook: Output<IntentFulfillmentActivityCodeHookArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value A description of the Lambda function that is run to fulfill the intent.
     * Required if type is CodeHook. Attributes are documented under code_hook.
     */
    @JvmName("qlwxpdnhiufhjfjg")
    public suspend fun codeHook(`value`: Output<IntentFulfillmentActivityCodeHookArgs>) {
        this.codeHook = value
    }

    /**
     * @param value How the intent should be fulfilled, either by running a Lambda function or by
     * returning the slot data to the client application. Type can be either `ReturnIntent` or `CodeHook`, as documented [here](https://docs.aws.amazon.com/lex/latest/dg/API_FulfillmentActivity.html).
     */
    @JvmName("ikrpciluyvfsipai")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value A description of the Lambda function that is run to fulfill the intent.
     * Required if type is CodeHook. Attributes are documented under code_hook.
     */
    @JvmName("nkwdamcgoqbeewdo")
    public suspend fun codeHook(`value`: IntentFulfillmentActivityCodeHookArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeHook = mapped
    }

    /**
     * @param argument A description of the Lambda function that is run to fulfill the intent.
     * Required if type is CodeHook. Attributes are documented under code_hook.
     */
    @JvmName("pavibdyodbxlalqg")
    public suspend
    fun codeHook(argument: suspend IntentFulfillmentActivityCodeHookArgsBuilder.() -> Unit) {
        val toBeMapped = IntentFulfillmentActivityCodeHookArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.codeHook = mapped
    }

    /**
     * @param value How the intent should be fulfilled, either by running a Lambda function or by
     * returning the slot data to the client application. Type can be either `ReturnIntent` or `CodeHook`, as documented [here](https://docs.aws.amazon.com/lex/latest/dg/API_FulfillmentActivity.html).
     */
    @JvmName("feckjdgemresvbvp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IntentFulfillmentActivityArgs = IntentFulfillmentActivityArgs(
        codeHook = codeHook,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
