@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.IntentFulfillmentActivityCodeHookArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property messageVersion The version of the request-response that you want Amazon Lex to use
 * to invoke your Lambda function. For more information, see
 * [Using Lambda Functions](https://docs.aws.amazon.com/lex/latest/dg/using-lambda.html). Must be less than or equal to 5 characters in length.
 * @property uri The Amazon Resource Name (ARN) of the Lambda function.
 */
public data class IntentFulfillmentActivityCodeHookArgs(
    public val messageVersion: Output<String>,
    public val uri: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.IntentFulfillmentActivityCodeHookArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.IntentFulfillmentActivityCodeHookArgs =
        com.pulumi.aws.lex.inputs.IntentFulfillmentActivityCodeHookArgs.builder()
            .messageVersion(messageVersion.applyValue({ args0 -> args0 }))
            .uri(uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntentFulfillmentActivityCodeHookArgs].
 */
@PulumiTagMarker
public class IntentFulfillmentActivityCodeHookArgsBuilder internal constructor() {
    private var messageVersion: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value The version of the request-response that you want Amazon Lex to use
     * to invoke your Lambda function. For more information, see
     * [Using Lambda Functions](https://docs.aws.amazon.com/lex/latest/dg/using-lambda.html). Must be less than or equal to 5 characters in length.
     */
    @JvmName("njfqcryfpdjjyhil")
    public suspend fun messageVersion(`value`: Output<String>) {
        this.messageVersion = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lambda function.
     */
    @JvmName("htffsnsswhvtqjpe")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The version of the request-response that you want Amazon Lex to use
     * to invoke your Lambda function. For more information, see
     * [Using Lambda Functions](https://docs.aws.amazon.com/lex/latest/dg/using-lambda.html). Must be less than or equal to 5 characters in length.
     */
    @JvmName("ahaoeveblaqguqml")
    public suspend fun messageVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageVersion = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lambda function.
     */
    @JvmName("gewvypiioqhopyny")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): IntentFulfillmentActivityCodeHookArgs =
        IntentFulfillmentActivityCodeHookArgs(
            messageVersion = messageVersion ?: throw PulumiNullFieldException("messageVersion"),
            uri = uri ?: throw PulumiNullFieldException("uri"),
        )
}
