@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.IntentRejectionStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property messages A set of messages, each of which provides a message string and its type.
 * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
 * Attributes are documented under message. Must contain between 1 and 15 messages.
 * @property responseCard The response card. Amazon Lex will substitute session attributes and
 * slot values into the response card. For more information, see
 * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
 */
public data class IntentRejectionStatementArgs(
    public val messages: Output<List<IntentRejectionStatementMessageArgs>>,
    public val responseCard: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.IntentRejectionStatementArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.IntentRejectionStatementArgs =
        com.pulumi.aws.lex.inputs.IntentRejectionStatementArgs.builder()
            .messages(
                messages.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseCard(responseCard?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntentRejectionStatementArgs].
 */
@PulumiTagMarker
public class IntentRejectionStatementArgsBuilder internal constructor() {
    private var messages: Output<List<IntentRejectionStatementMessageArgs>>? = null

    private var responseCard: Output<String>? = null

    /**
     * @param value A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("scwxymiwdisarojt")
    public suspend fun messages(`value`: Output<List<IntentRejectionStatementMessageArgs>>) {
        this.messages = value
    }

    @JvmName("kdtktphbhcgketwf")
    public suspend fun messages(vararg values: Output<IntentRejectionStatementMessageArgs>) {
        this.messages = Output.all(values.asList())
    }

    /**
     * @param values A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("dkcrfgicafgchbvt")
    public suspend fun messages(values: List<Output<IntentRejectionStatementMessageArgs>>) {
        this.messages = Output.all(values)
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
     */
    @JvmName("hyhxtqrkomiwsrys")
    public suspend fun responseCard(`value`: Output<String>) {
        this.responseCard = value
    }

    /**
     * @param value A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("ucuhrrtmwoswgiba")
    public suspend fun messages(`value`: List<IntentRejectionStatementMessageArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("rkrrgcvhqlogktha")
    public suspend
    fun messages(argument: List<suspend IntentRejectionStatementMessageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IntentRejectionStatementMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("fixccmmbhlkvywvn")
    public suspend fun messages(
        vararg
        argument: suspend IntentRejectionStatementMessageArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IntentRejectionStatementMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("pmgbgfyrxtwbdvhb")
    public suspend
    fun messages(argument: suspend IntentRejectionStatementMessageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IntentRejectionStatementMessageArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param values A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("akthvnsdrsueogie")
    public suspend fun messages(vararg values: IntentRejectionStatementMessageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
     */
    @JvmName("hlbgqwskqoqcsqjk")
    public suspend fun responseCard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCard = mapped
    }

    internal fun build(): IntentRejectionStatementArgs = IntentRejectionStatementArgs(
        messages = messages ?: throw PulumiNullFieldException("messages"),
        responseCard = responseCard,
    )
}
