@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.IntentSlotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property description A description of the bot. Must be less than or equal to 200 characters in length.
 * @property name The name of the intent slot that you want to create. The name is case sensitive. Must be less than or equal to 100 characters in length.
 * @property priority Directs Lex the order in which to elicit this slot value from the user.
 * For example, if the intent has two slots with priorities 1 and 2, AWS Lex first elicits a value for
 * the slot with priority 1. If multiple slots share the same priority, the order in which Lex elicits
 * values is arbitrary. Must be between 1 and 100.
 * @property responseCard The response card. Amazon Lex will substitute session attributes and
 * slot values into the response card. For more information, see
 * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
 * @property sampleUtterances If you know a specific pattern with which users might respond to
 * an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy. This
 * is optional. In most cases, Amazon Lex is capable of understanding user utterances. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
 * @property slotConstraint Specifies whether the slot is required or optional.
 * @property slotType The type of the slot, either a custom slot type that you defined or one of
 * the built-in slot types. Must be less than or equal to 100 characters in length.
 * @property slotTypeVersion The version of the slot type. Must be less than or equal to 64 characters in length.
 * @property valueElicitationPrompt The prompt that Amazon Lex uses to elicit the slot value
 * from the user. Attributes are documented under prompt.
 */
public data class IntentSlotArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>,
    public val priority: Output<Int>? = null,
    public val responseCard: Output<String>? = null,
    public val sampleUtterances: Output<List<String>>? = null,
    public val slotConstraint: Output<String>,
    public val slotType: Output<String>,
    public val slotTypeVersion: Output<String>? = null,
    public val valueElicitationPrompt: Output<IntentSlotValueElicitationPromptArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.IntentSlotArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.IntentSlotArgs =
        com.pulumi.aws.lex.inputs.IntentSlotArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .responseCard(responseCard?.applyValue({ args0 -> args0 }))
            .sampleUtterances(sampleUtterances?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .slotConstraint(slotConstraint.applyValue({ args0 -> args0 }))
            .slotType(slotType.applyValue({ args0 -> args0 }))
            .slotTypeVersion(slotTypeVersion?.applyValue({ args0 -> args0 }))
            .valueElicitationPrompt(
                valueElicitationPrompt?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [IntentSlotArgs].
 */
@PulumiTagMarker
public class IntentSlotArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var responseCard: Output<String>? = null

    private var sampleUtterances: Output<List<String>>? = null

    private var slotConstraint: Output<String>? = null

    private var slotType: Output<String>? = null

    private var slotTypeVersion: Output<String>? = null

    private var valueElicitationPrompt: Output<IntentSlotValueElicitationPromptArgs>? = null

    /**
     * @param value A description of the bot. Must be less than or equal to 200 characters in length.
     */
    @JvmName("tiaagsoubowcpjme")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the intent slot that you want to create. The name is case sensitive. Must be less than or equal to 100 characters in length.
     */
    @JvmName("htmwnaexncrqirxq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Directs Lex the order in which to elicit this slot value from the user.
     * For example, if the intent has two slots with priorities 1 and 2, AWS Lex first elicits a value for
     * the slot with priority 1. If multiple slots share the same priority, the order in which Lex elicits
     * values is arbitrary. Must be between 1 and 100.
     */
    @JvmName("fjywqfvyxvddnwuk")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
     */
    @JvmName("qukejroubeqjhqvs")
    public suspend fun responseCard(`value`: Output<String>) {
        this.responseCard = value
    }

    /**
     * @param value If you know a specific pattern with which users might respond to
     * an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy. This
     * is optional. In most cases, Amazon Lex is capable of understanding user utterances. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
     */
    @JvmName("khtsfhtxssaygcfb")
    public suspend fun sampleUtterances(`value`: Output<List<String>>) {
        this.sampleUtterances = value
    }

    @JvmName("rbavjdgaerrhlxos")
    public suspend fun sampleUtterances(vararg values: Output<String>) {
        this.sampleUtterances = Output.all(values.asList())
    }

    /**
     * @param values If you know a specific pattern with which users might respond to
     * an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy. This
     * is optional. In most cases, Amazon Lex is capable of understanding user utterances. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
     */
    @JvmName("bniguarkdipwbjqx")
    public suspend fun sampleUtterances(values: List<Output<String>>) {
        this.sampleUtterances = Output.all(values)
    }

    /**
     * @param value Specifies whether the slot is required or optional.
     */
    @JvmName("ugskkntijjoxtkup")
    public suspend fun slotConstraint(`value`: Output<String>) {
        this.slotConstraint = value
    }

    /**
     * @param value The type of the slot, either a custom slot type that you defined or one of
     * the built-in slot types. Must be less than or equal to 100 characters in length.
     */
    @JvmName("hrmsgqtdfscyhraa")
    public suspend fun slotType(`value`: Output<String>) {
        this.slotType = value
    }

    /**
     * @param value The version of the slot type. Must be less than or equal to 64 characters in length.
     */
    @JvmName("bqfkodqmuiwsyspr")
    public suspend fun slotTypeVersion(`value`: Output<String>) {
        this.slotTypeVersion = value
    }

    /**
     * @param value The prompt that Amazon Lex uses to elicit the slot value
     * from the user. Attributes are documented under prompt.
     */
    @JvmName("xqorecnsqjconkgb")
    public suspend fun valueElicitationPrompt(`value`: Output<IntentSlotValueElicitationPromptArgs>) {
        this.valueElicitationPrompt = value
    }

    /**
     * @param value A description of the bot. Must be less than or equal to 200 characters in length.
     */
    @JvmName("vodfdpxtfppaanbc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the intent slot that you want to create. The name is case sensitive. Must be less than or equal to 100 characters in length.
     */
    @JvmName("sifhpttfwognlhcx")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Directs Lex the order in which to elicit this slot value from the user.
     * For example, if the intent has two slots with priorities 1 and 2, AWS Lex first elicits a value for
     * the slot with priority 1. If multiple slots share the same priority, the order in which Lex elicits
     * values is arbitrary. Must be between 1 and 100.
     */
    @JvmName("nnkalpqprprkialw")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
     */
    @JvmName("uroikgrwyfjyugrf")
    public suspend fun responseCard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCard = mapped
    }

    /**
     * @param value If you know a specific pattern with which users might respond to
     * an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy. This
     * is optional. In most cases, Amazon Lex is capable of understanding user utterances. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
     */
    @JvmName("lrtyeijahtsvmfjy")
    public suspend fun sampleUtterances(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sampleUtterances = mapped
    }

    /**
     * @param values If you know a specific pattern with which users might respond to
     * an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy. This
     * is optional. In most cases, Amazon Lex is capable of understanding user utterances. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
     */
    @JvmName("xvcqttvfhekhvind")
    public suspend fun sampleUtterances(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sampleUtterances = mapped
    }

    /**
     * @param value Specifies whether the slot is required or optional.
     */
    @JvmName("wfirsbiroafgbwub")
    public suspend fun slotConstraint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slotConstraint = mapped
    }

    /**
     * @param value The type of the slot, either a custom slot type that you defined or one of
     * the built-in slot types. Must be less than or equal to 100 characters in length.
     */
    @JvmName("tgdgyqtqtnjvaofc")
    public suspend fun slotType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slotType = mapped
    }

    /**
     * @param value The version of the slot type. Must be less than or equal to 64 characters in length.
     */
    @JvmName("srqbdgsvjqbdpthv")
    public suspend fun slotTypeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slotTypeVersion = mapped
    }

    /**
     * @param value The prompt that Amazon Lex uses to elicit the slot value
     * from the user. Attributes are documented under prompt.
     */
    @JvmName("icfqkwjlfuxjkcvn")
    public suspend fun valueElicitationPrompt(`value`: IntentSlotValueElicitationPromptArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.valueElicitationPrompt = mapped
    }

    /**
     * @param argument The prompt that Amazon Lex uses to elicit the slot value
     * from the user. Attributes are documented under prompt.
     */
    @JvmName("yreumomatvqhskcy")
    public suspend
    fun valueElicitationPrompt(argument: suspend IntentSlotValueElicitationPromptArgsBuilder.() -> Unit) {
        val toBeMapped = IntentSlotValueElicitationPromptArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.valueElicitationPrompt = mapped
    }

    internal fun build(): IntentSlotArgs = IntentSlotArgs(
        description = description,
        name = name ?: throw PulumiNullFieldException("name"),
        priority = priority,
        responseCard = responseCard,
        sampleUtterances = sampleUtterances,
        slotConstraint = slotConstraint ?: throw PulumiNullFieldException("slotConstraint"),
        slotType = slotType ?: throw PulumiNullFieldException("slotType"),
        slotTypeVersion = slotTypeVersion,
        valueElicitationPrompt = valueElicitationPrompt,
    )
}
