@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.IntentSlotValueElicitationPromptArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property maxAttempts The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
 * @property messages A set of messages, each of which provides a message string and its type.
 * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
 * Attributes are documented under message. Must contain between 1 and 15 messages.
 * @property responseCard The response card. Amazon Lex will substitute session attributes and
 * slot values into the response card. For more information, see
 * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
 */
public data class IntentSlotValueElicitationPromptArgs(
    public val maxAttempts: Output<Int>,
    public val messages: Output<List<IntentSlotValueElicitationPromptMessageArgs>>,
    public val responseCard: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.IntentSlotValueElicitationPromptArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.IntentSlotValueElicitationPromptArgs =
        com.pulumi.aws.lex.inputs.IntentSlotValueElicitationPromptArgs.builder()
            .maxAttempts(maxAttempts.applyValue({ args0 -> args0 }))
            .messages(
                messages.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .responseCard(responseCard?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntentSlotValueElicitationPromptArgs].
 */
@PulumiTagMarker
public class IntentSlotValueElicitationPromptArgsBuilder internal constructor() {
    private var maxAttempts: Output<Int>? = null

    private var messages: Output<List<IntentSlotValueElicitationPromptMessageArgs>>? = null

    private var responseCard: Output<String>? = null

    /**
     * @param value The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
     */
    @JvmName("murbovgwuwpynstl")
    public suspend fun maxAttempts(`value`: Output<Int>) {
        this.maxAttempts = value
    }

    /**
     * @param value A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("mcmllybiempvxklv")
    public suspend fun messages(`value`: Output<List<IntentSlotValueElicitationPromptMessageArgs>>) {
        this.messages = value
    }

    @JvmName("qmhpmvcilbudougu")
    public suspend fun messages(vararg values: Output<IntentSlotValueElicitationPromptMessageArgs>) {
        this.messages = Output.all(values.asList())
    }

    /**
     * @param values A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("lpwfsswoercgubdv")
    public suspend fun messages(values: List<Output<IntentSlotValueElicitationPromptMessageArgs>>) {
        this.messages = Output.all(values)
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
     */
    @JvmName("hwoconqmaebydfge")
    public suspend fun responseCard(`value`: Output<String>) {
        this.responseCard = value
    }

    /**
     * @param value The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
     */
    @JvmName("leljvlaekbyatmpi")
    public suspend fun maxAttempts(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxAttempts = mapped
    }

    /**
     * @param value A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("flmrnhvcraatpbwf")
    public suspend fun messages(`value`: List<IntentSlotValueElicitationPromptMessageArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("qdygjkmixmbnlekd")
    public suspend
    fun messages(argument: List<suspend IntentSlotValueElicitationPromptMessageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IntentSlotValueElicitationPromptMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("waxrhrukdnbtfopn")
    public suspend fun messages(
        vararg
        argument: suspend IntentSlotValueElicitationPromptMessageArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IntentSlotValueElicitationPromptMessageArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param argument A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("hgclgnrjlqsrodrn")
    public suspend
    fun messages(argument: suspend IntentSlotValueElicitationPromptMessageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IntentSlotValueElicitationPromptMessageArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.messages = mapped
    }

    /**
     * @param values A set of messages, each of which provides a message string and its type.
     * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
     * Attributes are documented under message. Must contain between 1 and 15 messages.
     */
    @JvmName("pucebohnwebmkbiq")
    public suspend fun messages(vararg values: IntentSlotValueElicitationPromptMessageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messages = mapped
    }

    /**
     * @param value The response card. Amazon Lex will substitute session attributes and
     * slot values into the response card. For more information, see
     * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
     */
    @JvmName("rfvsrgufnpbpdnki")
    public suspend fun responseCard(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseCard = mapped
    }

    internal fun build(): IntentSlotValueElicitationPromptArgs = IntentSlotValueElicitationPromptArgs(
        maxAttempts = maxAttempts ?: throw PulumiNullFieldException("maxAttempts"),
        messages = messages ?: throw PulumiNullFieldException("messages"),
        responseCard = responseCard,
    )
}
