@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.SlotTypeEnumerationValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property synonyms Additional values related to the slot type value. Each item must be less than or equal to 140 characters in length.
 * @property value The value of the slot type. Must be less than or equal to 140 characters in length.
 */
public data class SlotTypeEnumerationValueArgs(
    public val synonyms: Output<List<String>>? = null,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.SlotTypeEnumerationValueArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.SlotTypeEnumerationValueArgs =
        com.pulumi.aws.lex.inputs.SlotTypeEnumerationValueArgs.builder()
            .synonyms(synonyms?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SlotTypeEnumerationValueArgs].
 */
@PulumiTagMarker
public class SlotTypeEnumerationValueArgsBuilder internal constructor() {
    private var synonyms: Output<List<String>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Additional values related to the slot type value. Each item must be less than or equal to 140 characters in length.
     */
    @JvmName("vfgiicifiaebwdsb")
    public suspend fun synonyms(`value`: Output<List<String>>) {
        this.synonyms = value
    }

    @JvmName("hrobfgskhtftplep")
    public suspend fun synonyms(vararg values: Output<String>) {
        this.synonyms = Output.all(values.asList())
    }

    /**
     * @param values Additional values related to the slot type value. Each item must be less than or equal to 140 characters in length.
     */
    @JvmName("hspetxaqxsdhfmwg")
    public suspend fun synonyms(values: List<Output<String>>) {
        this.synonyms = Output.all(values)
    }

    /**
     * @param value The value of the slot type. Must be less than or equal to 140 characters in length.
     */
    @JvmName("knjrievoljpawngb")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Additional values related to the slot type value. Each item must be less than or equal to 140 characters in length.
     */
    @JvmName("jxdgnqhrcnejldop")
    public suspend fun synonyms(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.synonyms = mapped
    }

    /**
     * @param values Additional values related to the slot type value. Each item must be less than or equal to 140 characters in length.
     */
    @JvmName("gxakgmcumbfsmjde")
    public suspend fun synonyms(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.synonyms = mapped
    }

    /**
     * @param value The value of the slot type. Must be less than or equal to 140 characters in length.
     */
    @JvmName("eqggyequilvcyott")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SlotTypeEnumerationValueArgs = SlotTypeEnumerationValueArgs(
        synonyms = synonyms,
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
