@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsBotLocaleTimeoutsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property create
 * @property delete
 * @property update
 */
public data class V2modelsBotLocaleTimeoutsArgs(
    public val create: Output<String>? = null,
    public val delete: Output<String>? = null,
    public val update: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsBotLocaleTimeoutsArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsBotLocaleTimeoutsArgs =
        com.pulumi.aws.lex.inputs.V2modelsBotLocaleTimeoutsArgs.builder()
            .create(create?.applyValue({ args0 -> args0 }))
            .delete(delete?.applyValue({ args0 -> args0 }))
            .update(update?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsBotLocaleTimeoutsArgs].
 */
@PulumiTagMarker
public class V2modelsBotLocaleTimeoutsArgsBuilder internal constructor() {
    private var create: Output<String>? = null

    private var delete: Output<String>? = null

    private var update: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("fcfvajpmcynqsvkq")
    public suspend fun create(`value`: Output<String>) {
        this.create = value
    }

    /**
     * @param value
     */
    @JvmName("nkmrtwslglfvards")
    public suspend fun delete(`value`: Output<String>) {
        this.delete = value
    }

    /**
     * @param value
     */
    @JvmName("sxfjwchbgjaikamv")
    public suspend fun update(`value`: Output<String>) {
        this.update = value
    }

    /**
     * @param value
     */
    @JvmName("jsqacgahcnoxxdxc")
    public suspend fun create(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.create = mapped
    }

    /**
     * @param value
     */
    @JvmName("xtnrtawfckddhsbv")
    public suspend fun delete(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delete = mapped
    }

    /**
     * @param value
     */
    @JvmName("kqhmtdcpwferpiip")
    public suspend fun update(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.update = mapped
    }

    internal fun build(): V2modelsBotLocaleTimeoutsArgs = V2modelsBotLocaleTimeoutsArgs(
        create = create,
        delete = delete,
        update = update,
    )
}
