@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsBotMemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property aliasId (Required) - Alias ID of a bot that is a member of this network of bots.
 * @property aliasName (Required) - Alias name of a bot that is a member of this network of bots.
 * @property id (Required) - Unique ID of a bot that is a member of this network of bots.
 * @property name Name of the bot. The bot name must be unique in the account that creates the bot. Type String. Length Constraints: Minimum length of 1. Maximum length of 100.
 * @property version (Required) - Version of a bot that is a member of this network of bots.
 */
public data class V2modelsBotMemberArgs(
    public val aliasId: Output<String>,
    public val aliasName: Output<String>,
    public val id: Output<String>,
    public val name: Output<String>,
    public val version: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsBotMemberArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsBotMemberArgs =
        com.pulumi.aws.lex.inputs.V2modelsBotMemberArgs.builder()
            .aliasId(aliasId.applyValue({ args0 -> args0 }))
            .aliasName(aliasName.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .version(version.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsBotMemberArgs].
 */
@PulumiTagMarker
public class V2modelsBotMemberArgsBuilder internal constructor() {
    private var aliasId: Output<String>? = null

    private var aliasName: Output<String>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value (Required) - Alias ID of a bot that is a member of this network of bots.
     */
    @JvmName("noshewrujlrwlgwt")
    public suspend fun aliasId(`value`: Output<String>) {
        this.aliasId = value
    }

    /**
     * @param value (Required) - Alias name of a bot that is a member of this network of bots.
     */
    @JvmName("ygoaabkenowbamed")
    public suspend fun aliasName(`value`: Output<String>) {
        this.aliasName = value
    }

    /**
     * @param value (Required) - Unique ID of a bot that is a member of this network of bots.
     */
    @JvmName("ayyueuwvlgubysqw")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the bot. The bot name must be unique in the account that creates the bot. Type String. Length Constraints: Minimum length of 1. Maximum length of 100.
     */
    @JvmName("tgqmwbefxbiqdble")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value (Required) - Version of a bot that is a member of this network of bots.
     */
    @JvmName("mbsvysgdrkspvtyj")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value (Required) - Alias ID of a bot that is a member of this network of bots.
     */
    @JvmName("ffcrjvwbgsbqugmi")
    public suspend fun aliasId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aliasId = mapped
    }

    /**
     * @param value (Required) - Alias name of a bot that is a member of this network of bots.
     */
    @JvmName("flvhugxfhodgsbvd")
    public suspend fun aliasName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aliasName = mapped
    }

    /**
     * @param value (Required) - Unique ID of a bot that is a member of this network of bots.
     */
    @JvmName("dxaynhgwqfolqujh")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the bot. The bot name must be unique in the account that creates the bot. Type String. Length Constraints: Minimum length of 1. Maximum length of 100.
     */
    @JvmName("lkgrpxkixlqjppuf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value (Required) - Version of a bot that is a member of this network of bots.
     */
    @JvmName("smokynigkciekxly")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): V2modelsBotMemberArgs = V2modelsBotMemberArgs(
        aliasId = aliasId ?: throw PulumiNullFieldException("aliasId"),
        aliasName = aliasName ?: throw PulumiNullFieldException("aliasName"),
        id = id ?: throw PulumiNullFieldException("id"),
        name = name ?: throw PulumiNullFieldException("name"),
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
