@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property messages A set of messages, each of which provides a message string and its type.
 * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
 * Attributes are documented under message.
 * @property responseCard The response card. Amazon Lex will substitute session attributes and
 * slot values into the response card. For more information, see
 * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html).
 */
public data class BotAbortStatement(
    public val messages: List<BotAbortStatementMessage>,
    public val responseCard: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.BotAbortStatement): BotAbortStatement =
            BotAbortStatement(
                messages = javaType.messages().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.BotAbortStatementMessage.Companion.toKotlin(args0)
                    })
                }),
                responseCard = javaType.responseCard().map({ args0 -> args0 }).orElse(null),
            )
    }
}
