@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destination The destination where logs are delivered. Options are `CLOUDWATCH_LOGS` or `S3`.
 * @property kmsKeyArn The Amazon Resource Name (ARN) of the key used to encrypt audio logs in an S3 bucket. This can only be specified when `destination` is set to `S3`. Must be between 20 and 2048 characters in length.
 * @property logType The type of logging that is enabled. Options are `AUDIO` or `TEXT`.
 * @property resourceArn The Amazon Resource Name (ARN) of the CloudWatch Logs log group or S3 bucket where the logs are delivered. Must be less than or equal to 2048 characters in length.
 * @property resourcePrefix The prefix of the S3 object key for `AUDIO` logs or the log stream name for `TEXT` logs.
 */
public data class BotAliasConversationLogsLogSetting(
    public val destination: String,
    public val kmsKeyArn: String? = null,
    public val logType: String,
    public val resourceArn: String,
    public val resourcePrefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.BotAliasConversationLogsLogSetting):
            BotAliasConversationLogsLogSetting = BotAliasConversationLogsLogSetting(
            destination = javaType.destination(),
            kmsKeyArn = javaType.kmsKeyArn().map({ args0 -> args0 }).orElse(null),
            logType = javaType.logType(),
            resourceArn = javaType.resourceArn(),
            resourcePrefix = javaType.resourcePrefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
