@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getIntent.
 * @property arn ARN of the Lex intent.
 * @property checksum Checksum identifying the version of the intent that was created. The checksum is not
 * included as an argument because the resource will add it automatically when updating the intent.
 * @property createdDate Date when the intent version was created.
 * @property description Description of the intent.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastUpdatedDate Date when the $LATEST version of this intent was updated.
 * @property name Name of the intent, not case sensitive.
 * @property parentIntentSignature A unique identifier for the built-in intent to base this
 * intent on. To find the signature for an intent, see
 * [Standard Built-in Intents](https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/built-in-intent-ref/standard-intents)
 * in the Alexa Skills Kit.
 * @property version Version of the bot.
 */
public data class GetIntentResult(
    public val arn: String,
    public val checksum: String,
    public val createdDate: String,
    public val description: String,
    public val id: String,
    public val lastUpdatedDate: String,
    public val name: String,
    public val parentIntentSignature: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.GetIntentResult): GetIntentResult =
            GetIntentResult(
                arn = javaType.arn(),
                checksum = javaType.checksum(),
                createdDate = javaType.createdDate(),
                description = javaType.description(),
                id = javaType.id(),
                lastUpdatedDate = javaType.lastUpdatedDate(),
                name = javaType.name(),
                parentIntentSignature = javaType.parentIntentSignature(),
                version = javaType.version().map({ args0 -> args0 }).orElse(null),
            )
    }
}
