@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSlotType.
 * @property checksum Checksum identifying the version of the slot type that was created. The checksum is
 * not included as an argument because the resource will add it automatically when updating the slot type.
 * @property createdDate Date when the slot type version was created.
 * @property description Description of the slot type.
 * @property enumerationValues Set of EnumerationValue objects that defines the values that
 * the slot type can take. Each value can have a set of synonyms, which are additional values that help
 * train the machine learning model about the values that it resolves for a slot.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastUpdatedDate Date when the $LATEST version of this slot type was updated.
 * @property name Name of the slot type. The name is not case sensitive.
 * @property valueSelectionStrategy Determines the slot resolution strategy that Amazon Lex
 * uses to return slot type values. `ORIGINAL_VALUE` returns the value entered by the user if the user
 * value is similar to the slot value. `TOP_RESOLUTION` returns the first value in the resolution list
 * if there is a resolution list for the slot, otherwise null is returned.
 * @property version Version of the slot type.
 */
public data class GetSlotTypeResult(
    public val checksum: String,
    public val createdDate: String,
    public val description: String,
    public val enumerationValues: List<GetSlotTypeEnumerationValue>,
    public val id: String,
    public val lastUpdatedDate: String,
    public val name: String,
    public val valueSelectionStrategy: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.GetSlotTypeResult): GetSlotTypeResult =
            GetSlotTypeResult(
                checksum = javaType.checksum(),
                createdDate = javaType.createdDate(),
                description = javaType.description(),
                enumerationValues = javaType.enumerationValues().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.GetSlotTypeEnumerationValue.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                lastUpdatedDate = javaType.lastUpdatedDate(),
                name = javaType.name(),
                valueSelectionStrategy = javaType.valueSelectionStrategy(),
                version = javaType.version().map({ args0 -> args0 }).orElse(null),
            )
    }
}
