@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property prompt Prompts for information from the user. Attributes are documented under prompt.
 * @property rejectionStatement If the user answers "no" to the question defined in the prompt field,
 * Amazon Lex responds with this statement to acknowledge that the intent was canceled. Attributes are
 * documented below under statement.
 */
public data class IntentFollowUpPrompt(
    public val prompt: IntentFollowUpPromptPrompt,
    public val rejectionStatement: IntentFollowUpPromptRejectionStatement,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.IntentFollowUpPrompt):
            IntentFollowUpPrompt = IntentFollowUpPrompt(
            prompt = javaType.prompt().let({ args0 ->
                com.pulumi.aws.lex.kotlin.outputs.IntentFollowUpPromptPrompt.Companion.toKotlin(args0)
            }),
            rejectionStatement = javaType.rejectionStatement().let({ args0 ->
                com.pulumi.aws.lex.kotlin.outputs.IntentFollowUpPromptRejectionStatement.Companion.toKotlin(args0)
            }),
        )
    }
}
