@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content The text of the message. Must be less than or equal to 1000 characters in length.
 * @property contentType The content type of the message string.
 * @property groupNumber Identifies the message group that the message belongs to. When a group
 * is assigned to a message, Amazon Lex returns one message from each group in the response. Must be a number between 1 and 5 (inclusive).
 */
public data class IntentFollowUpPromptRejectionStatementMessage(
    public val content: String,
    public val contentType: String,
    public val groupNumber: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.lex.outputs.IntentFollowUpPromptRejectionStatementMessage):
            IntentFollowUpPromptRejectionStatementMessage =
            IntentFollowUpPromptRejectionStatementMessage(
                content = javaType.content(),
                contentType = javaType.contentType(),
                groupNumber = javaType.groupNumber().map({ args0 -> args0 }).orElse(null),
            )
    }
}
