@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property aliasId (Required) - Alias ID of a bot that is a member of this network of bots.
 * @property aliasName (Required) - Alias name of a bot that is a member of this network of bots.
 * @property id (Required) - Unique ID of a bot that is a member of this network of bots.
 * @property name Name of the bot. The bot name must be unique in the account that creates the bot. Type String. Length Constraints: Minimum length of 1. Maximum length of 100.
 * @property version (Required) - Version of a bot that is a member of this network of bots.
 */
public data class V2modelsBotMember(
    public val aliasId: String,
    public val aliasName: String,
    public val id: String,
    public val name: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsBotMember): V2modelsBotMember =
            V2modelsBotMember(
                aliasId = javaType.aliasId(),
                aliasName = javaType.aliasName(),
                id = javaType.id(),
                name = javaType.name(),
                version = javaType.version(),
            )
    }
}
