@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin

import com.pulumi.aws.licensemanager.AssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a License Manager association.
 * > **Note:** License configurations can also be associated with launch templates by specifying the `license_specifications` block for an `aws.ec2.LaunchTemplate`.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.licensemanager.LicenseConfiguration;
 * import com.pulumi.aws.licensemanager.LicenseConfigurationArgs;
 * import com.pulumi.aws.licensemanager.Association;
 * import com.pulumi.aws.licensemanager.AssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var exampleAmi = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .owners("amazon")
 *             .filters(GetAmiFilterArgs.builder()
 *                 .name("name")
 *                 .values("amzn-ami-vpc-nat*")
 *                 .build())
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .ami(exampleAmi.applyValue(getAmiResult -> getAmiResult.id()))
 *             .instanceType("t2.micro")
 *             .build());
 *         var exampleLicenseConfiguration = new LicenseConfiguration("exampleLicenseConfiguration", LicenseConfigurationArgs.builder()
 *             .licenseCountingType("Instance")
 *             .build());
 *         var exampleAssociation = new Association("exampleAssociation", AssociationArgs.builder()
 *             .licenseConfigurationArn(exampleLicenseConfiguration.arn())
 *             .resourceArn(exampleInstance.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import license configurations using `resource_arn,license_configuration_arn`. For example:
 * ```sh
 *  $ pulumi import aws:licensemanager/association:Association example arn:aws:ec2:eu-west-1:123456789012:image/ami-123456789abcdef01,arn:aws:license-manager:eu-west-1:123456789012:license-configuration:lic-0123456789abcdef0123456789abcdef
 * ```
 * @property licenseConfigurationArn ARN of the license configuration.
 * @property resourceArn ARN of the resource associated with the license configuration.
 */
public data class AssociationArgs(
    public val licenseConfigurationArn: Output<String>? = null,
    public val resourceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.licensemanager.AssociationArgs> {
    override fun toJava(): com.pulumi.aws.licensemanager.AssociationArgs =
        com.pulumi.aws.licensemanager.AssociationArgs.builder()
            .licenseConfigurationArn(licenseConfigurationArn?.applyValue({ args0 -> args0 }))
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssociationArgs].
 */
@PulumiTagMarker
public class AssociationArgsBuilder internal constructor() {
    private var licenseConfigurationArn: Output<String>? = null

    private var resourceArn: Output<String>? = null

    /**
     * @param value ARN of the license configuration.
     */
    @JvmName("rkvheqrdwflmbqmo")
    public suspend fun licenseConfigurationArn(`value`: Output<String>) {
        this.licenseConfigurationArn = value
    }

    /**
     * @param value ARN of the resource associated with the license configuration.
     */
    @JvmName("opgwacesbuymismg")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value ARN of the license configuration.
     */
    @JvmName("pltrtvnauqpfmubv")
    public suspend fun licenseConfigurationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseConfigurationArn = mapped
    }

    /**
     * @param value ARN of the resource associated with the license configuration.
     */
    @JvmName("ogmdstvjkehadloe")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    internal fun build(): AssociationArgs = AssociationArgs(
        licenseConfigurationArn = licenseConfigurationArn,
        resourceArn = resourceArn,
    )
}
