@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [LicenseConfiguration].
 */
@PulumiTagMarker
public class LicenseConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LicenseConfigurationArgs = LicenseConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LicenseConfigurationArgsBuilder.() -> Unit) {
        val builder = LicenseConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LicenseConfiguration {
        val builtJavaResource =
            com.pulumi.aws.licensemanager.LicenseConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LicenseConfiguration(builtJavaResource)
    }
}

/**
 * Provides a License Manager license configuration resource.
 * > **Note:** Removing the `license_count` attribute is not supported by the License Manager API.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.licensemanager.LicenseConfiguration;
 * import com.pulumi.aws.licensemanager.LicenseConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LicenseConfiguration("example", LicenseConfigurationArgs.builder()
 *             .description("Example")
 *             .licenseCount(10)
 *             .licenseCountHardLimit(true)
 *             .licenseCountingType("Socket")
 *             .licenseRules("#minimumSockets=2")
 *             .tags(Map.of("foo", "barr"))
 *             .build());
 *     }
 * }
 * ```
 * ## Rules
 * License rules should be in the format of `#RuleType=RuleValue`. Supported rule types:
 * * `minimumVcpus` - Resource must have minimum vCPU count in order to use the license. Default: 1
 * * `maximumVcpus` - Resource must have maximum vCPU count in order to use the license. Default: unbounded, limit: 10000
 * * `minimumCores` - Resource must have minimum core count in order to use the license. Default: 1
 * * `maximumCores` - Resource must have maximum core count in order to use the license. Default: unbounded, limit: 10000
 * * `minimumSockets` - Resource must have minimum socket count in order to use the license. Default: 1
 * * `maximumSockets` - Resource must have maximum socket count in order to use the license. Default: unbounded, limit: 10000
 * * `allowedTenancy` - Defines where the license can be used. If set, restricts license usage to selected tenancies. Specify a comma delimited list of `EC2-Default`, `EC2-DedicatedHost`, `EC2-DedicatedInstance`
 * ## Import
 * Using `pulumi import`, import license configurations using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:licensemanager/licenseConfiguration:LicenseConfiguration example arn:aws:license-manager:eu-west-1:123456789012:license-configuration:lic-0123456789abcdef0123456789abcdef
 * ```
 *
 */
public class LicenseConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.licensemanager.LicenseConfiguration,
) : KotlinCustomResource(javaResource, LicenseConfigurationMapper) {
    /**
     * The license configuration ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the license configuration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of licenses managed by the license configuration.
     */
    public val licenseCount: Output<Int>?
        get() = javaResource.licenseCount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Sets the number of available licenses as a hard limit.
     */
    public val licenseCountHardLimit: Output<Boolean>?
        get() = javaResource.licenseCountHardLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Dimension to use to track license inventory. Specify either `vCPU`, `Instance`, `Core` or `Socket`.
     */
    public val licenseCountingType: Output<String>
        get() = javaResource.licenseCountingType().applyValue({ args0 -> args0 })

    /**
     * Array of configured License Manager rules.
     */
    public val licenseRules: Output<List<String>>?
        get() = javaResource.licenseRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Name of the license configuration.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Account ID of the owner of the license configuration.
     */
    public val ownerAccountId: Output<String>
        get() = javaResource.ownerAccountId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object LicenseConfigurationMapper : ResourceMapper<LicenseConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.licensemanager.LicenseConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): LicenseConfiguration = LicenseConfiguration(
        javaResource
            as com.pulumi.aws.licensemanager.LicenseConfiguration,
    )
}

/**
 * @see [LicenseConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LicenseConfiguration].
 */
public suspend fun licenseConfiguration(
    name: String,
    block: suspend LicenseConfigurationResourceBuilder.() -> Unit,
): LicenseConfiguration {
    val builder = LicenseConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LicenseConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun licenseConfiguration(name: String): LicenseConfiguration {
    val builder = LicenseConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
