@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin

import com.pulumi.aws.licensemanager.LicenseConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a License Manager license configuration resource.
 * > **Note:** Removing the `license_count` attribute is not supported by the License Manager API.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.licensemanager.LicenseConfiguration;
 * import com.pulumi.aws.licensemanager.LicenseConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LicenseConfiguration("example", LicenseConfigurationArgs.builder()
 *             .description("Example")
 *             .licenseCount(10)
 *             .licenseCountHardLimit(true)
 *             .licenseCountingType("Socket")
 *             .licenseRules("#minimumSockets=2")
 *             .tags(Map.of("foo", "barr"))
 *             .build());
 *     }
 * }
 * ```
 * ## Rules
 * License rules should be in the format of `#RuleType=RuleValue`. Supported rule types:
 * * `minimumVcpus` - Resource must have minimum vCPU count in order to use the license. Default: 1
 * * `maximumVcpus` - Resource must have maximum vCPU count in order to use the license. Default: unbounded, limit: 10000
 * * `minimumCores` - Resource must have minimum core count in order to use the license. Default: 1
 * * `maximumCores` - Resource must have maximum core count in order to use the license. Default: unbounded, limit: 10000
 * * `minimumSockets` - Resource must have minimum socket count in order to use the license. Default: 1
 * * `maximumSockets` - Resource must have maximum socket count in order to use the license. Default: unbounded, limit: 10000
 * * `allowedTenancy` - Defines where the license can be used. If set, restricts license usage to selected tenancies. Specify a comma delimited list of `EC2-Default`, `EC2-DedicatedHost`, `EC2-DedicatedInstance`
 * ## Import
 * Using `pulumi import`, import license configurations using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:licensemanager/licenseConfiguration:LicenseConfiguration example arn:aws:license-manager:eu-west-1:123456789012:license-configuration:lic-0123456789abcdef0123456789abcdef
 * ```
 * @property description Description of the license configuration.
 * @property licenseCount Number of licenses managed by the license configuration.
 * @property licenseCountHardLimit Sets the number of available licenses as a hard limit.
 * @property licenseCountingType Dimension to use to track license inventory. Specify either `vCPU`, `Instance`, `Core` or `Socket`.
 * @property licenseRules Array of configured License Manager rules.
 * @property name Name of the license configuration.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LicenseConfigurationArgs(
    public val description: Output<String>? = null,
    public val licenseCount: Output<Int>? = null,
    public val licenseCountHardLimit: Output<Boolean>? = null,
    public val licenseCountingType: Output<String>? = null,
    public val licenseRules: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.licensemanager.LicenseConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.licensemanager.LicenseConfigurationArgs =
        com.pulumi.aws.licensemanager.LicenseConfigurationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .licenseCount(licenseCount?.applyValue({ args0 -> args0 }))
            .licenseCountHardLimit(licenseCountHardLimit?.applyValue({ args0 -> args0 }))
            .licenseCountingType(licenseCountingType?.applyValue({ args0 -> args0 }))
            .licenseRules(licenseRules?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LicenseConfigurationArgs].
 */
@PulumiTagMarker
public class LicenseConfigurationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var licenseCount: Output<Int>? = null

    private var licenseCountHardLimit: Output<Boolean>? = null

    private var licenseCountingType: Output<String>? = null

    private var licenseRules: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description of the license configuration.
     */
    @JvmName("hhndouewfmdyhafb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Number of licenses managed by the license configuration.
     */
    @JvmName("jpxulvubdpsqtysk")
    public suspend fun licenseCount(`value`: Output<Int>) {
        this.licenseCount = value
    }

    /**
     * @param value Sets the number of available licenses as a hard limit.
     */
    @JvmName("qiqeqaylgiomiqlp")
    public suspend fun licenseCountHardLimit(`value`: Output<Boolean>) {
        this.licenseCountHardLimit = value
    }

    /**
     * @param value Dimension to use to track license inventory. Specify either `vCPU`, `Instance`, `Core` or `Socket`.
     */
    @JvmName("dwwruhcyuojbpwpq")
    public suspend fun licenseCountingType(`value`: Output<String>) {
        this.licenseCountingType = value
    }

    /**
     * @param value Array of configured License Manager rules.
     */
    @JvmName("uydamaiubperqthc")
    public suspend fun licenseRules(`value`: Output<List<String>>) {
        this.licenseRules = value
    }

    @JvmName("jqaxwasdymfjhnhp")
    public suspend fun licenseRules(vararg values: Output<String>) {
        this.licenseRules = Output.all(values.asList())
    }

    /**
     * @param values Array of configured License Manager rules.
     */
    @JvmName("jervfhcxxyjdvvce")
    public suspend fun licenseRules(values: List<Output<String>>) {
        this.licenseRules = Output.all(values)
    }

    /**
     * @param value Name of the license configuration.
     */
    @JvmName("gomjvdkrtnmrnoyl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ikbjagopnksmtxww")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description of the license configuration.
     */
    @JvmName("jayblsnhxuidqinf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Number of licenses managed by the license configuration.
     */
    @JvmName("irsuebxtvsikifai")
    public suspend fun licenseCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseCount = mapped
    }

    /**
     * @param value Sets the number of available licenses as a hard limit.
     */
    @JvmName("rwemechawsdwfwfb")
    public suspend fun licenseCountHardLimit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseCountHardLimit = mapped
    }

    /**
     * @param value Dimension to use to track license inventory. Specify either `vCPU`, `Instance`, `Core` or `Socket`.
     */
    @JvmName("swjbcqceqqucmaxf")
    public suspend fun licenseCountingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseCountingType = mapped
    }

    /**
     * @param value Array of configured License Manager rules.
     */
    @JvmName("bqcqejrwklhoyblx")
    public suspend fun licenseRules(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseRules = mapped
    }

    /**
     * @param values Array of configured License Manager rules.
     */
    @JvmName("mcaqxbbdhpcfyhec")
    public suspend fun licenseRules(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseRules = mapped
    }

    /**
     * @param value Name of the license configuration.
     */
    @JvmName("jgmrspxldgyexqlc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rifqnrtvhitqopny")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kevpdedewvdwkimi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LicenseConfigurationArgs = LicenseConfigurationArgs(
        description = description,
        licenseCount = licenseCount,
        licenseCountHardLimit = licenseCountHardLimit,
        licenseCountingType = licenseCountingType,
        licenseRules = licenseRules,
        name = name,
        tags = tags,
    )
}
