@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [LicenseGrant].
 */
@PulumiTagMarker
public class LicenseGrantResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LicenseGrantArgs = LicenseGrantArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LicenseGrantArgsBuilder.() -> Unit) {
        val builder = LicenseGrantArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LicenseGrant {
        val builtJavaResource = com.pulumi.aws.licensemanager.LicenseGrant(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LicenseGrant(builtJavaResource)
    }
}

/**
 * Provides a License Manager grant. This allows for sharing licenses with other AWS accounts.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.licensemanager.LicenseGrant;
 * import com.pulumi.aws.licensemanager.LicenseGrantArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new LicenseGrant("test", LicenseGrantArgs.builder()
 *             .allowedOperations(
 *                 "ListPurchasedLicenses",
 *                 "CheckoutLicense",
 *                 "CheckInLicense",
 *                 "ExtendConsumptionLicense",
 *                 "CreateToken")
 *             .homeRegion("us-east-1")
 *             .licenseArn("arn:aws:license-manager::111111111111:license:l-exampleARN")
 *             .principal("arn:aws:iam::111111111112:root")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_licensemanager_grant` using the grant arn. For example:
 * ```sh
 *  $ pulumi import aws:licensemanager/licenseGrant:LicenseGrant test arn:aws:license-manager::123456789011:grant:g-01d313393d9e443d8664cc054db1e089
 * ```
 *
 */
public class LicenseGrant internal constructor(
    override val javaResource: com.pulumi.aws.licensemanager.LicenseGrant,
) : KotlinCustomResource(javaResource, LicenseGrantMapper) {
    /**
     * A list of the allowed operations for the grant. This is a subset of the allowed operations on the license.
     */
    public val allowedOperations: Output<List<String>>
        get() = javaResource.allowedOperations().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The grant ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The home region for the license.
     */
    public val homeRegion: Output<String>
        get() = javaResource.homeRegion().applyValue({ args0 -> args0 })

    /**
     * The ARN of the license to grant.
     */
    public val licenseArn: Output<String>
        get() = javaResource.licenseArn().applyValue({ args0 -> args0 })

    /**
     * The Name of the grant.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parent ARN.
     */
    public val parentArn: Output<String>
        get() = javaResource.parentArn().applyValue({ args0 -> args0 })

    /**
     * The target account for the grant in the form of the ARN for an account principal of the root user.
     */
    public val principal: Output<String>
        get() = javaResource.principal().applyValue({ args0 -> args0 })

    /**
     * The grant status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The grant version.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object LicenseGrantMapper : ResourceMapper<LicenseGrant> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.licensemanager.LicenseGrant::class == javaResource::class

    override fun map(javaResource: Resource): LicenseGrant = LicenseGrant(
        javaResource as
            com.pulumi.aws.licensemanager.LicenseGrant,
    )
}

/**
 * @see [LicenseGrant].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LicenseGrant].
 */
public suspend fun licenseGrant(
    name: String,
    block: suspend LicenseGrantResourceBuilder.() -> Unit,
): LicenseGrant {
    val builder = LicenseGrantResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LicenseGrant].
 * @param name The _unique_ name of the resulting resource.
 */
public fun licenseGrant(name: String): LicenseGrant {
    val builder = LicenseGrantResourceBuilder()
    builder.name(name)
    return builder.build()
}
