@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [LicenseGrantAccepter].
 */
@PulumiTagMarker
public class LicenseGrantAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LicenseGrantAccepterArgs = LicenseGrantAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LicenseGrantAccepterArgsBuilder.() -> Unit) {
        val builder = LicenseGrantAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LicenseGrantAccepter {
        val builtJavaResource =
            com.pulumi.aws.licensemanager.LicenseGrantAccepter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LicenseGrantAccepter(builtJavaResource)
    }
}

/**
 * Accepts a License Manager grant. This allows for sharing licenses with other aws accounts.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.licensemanager.LicenseGrantAccepter;
 * import com.pulumi.aws.licensemanager.LicenseGrantAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new LicenseGrantAccepter("test", LicenseGrantAccepterArgs.builder()
 *             .grantArn("arn:aws:license-manager::123456789012:grant:g-1cf9fba4ba2f42dcab11c686c4b4d329")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_licensemanager_grant_accepter` using the grant arn. For example:
 * ```sh
 *  $ pulumi import aws:licensemanager/licenseGrantAccepter:LicenseGrantAccepter test arn:aws:license-manager::123456789012:grant:g-1cf9fba4ba2f42dcab11c686c4b4d329
 * ```
 *
 */
public class LicenseGrantAccepter internal constructor(
    override val javaResource: com.pulumi.aws.licensemanager.LicenseGrantAccepter,
) : KotlinCustomResource(javaResource, LicenseGrantAccepterMapper) {
    /**
     * A list of the allowed operations for the grant.
     */
    public val allowedOperations: Output<List<String>>
        get() = javaResource.allowedOperations().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The ARN of the grant to accept.
     */
    public val grantArn: Output<String>
        get() = javaResource.grantArn().applyValue({ args0 -> args0 })

    /**
     * The home region for the license.
     */
    public val homeRegion: Output<String>
        get() = javaResource.homeRegion().applyValue({ args0 -> args0 })

    /**
     * The ARN of the license for the grant.
     */
    public val licenseArn: Output<String>
        get() = javaResource.licenseArn().applyValue({ args0 -> args0 })

    /**
     * The Name of the grant.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parent ARN.
     */
    public val parentArn: Output<String>
        get() = javaResource.parentArn().applyValue({ args0 -> args0 })

    /**
     * The target account for the grant.
     */
    public val principal: Output<String>
        get() = javaResource.principal().applyValue({ args0 -> args0 })

    /**
     * The grant status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The grant version.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object LicenseGrantAccepterMapper : ResourceMapper<LicenseGrantAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.licensemanager.LicenseGrantAccepter::class == javaResource::class

    override fun map(javaResource: Resource): LicenseGrantAccepter = LicenseGrantAccepter(
        javaResource
            as com.pulumi.aws.licensemanager.LicenseGrantAccepter,
    )
}

/**
 * @see [LicenseGrantAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LicenseGrantAccepter].
 */
public suspend fun licenseGrantAccepter(
    name: String,
    block: suspend LicenseGrantAccepterResourceBuilder.() -> Unit,
): LicenseGrantAccepter {
    val builder = LicenseGrantAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LicenseGrantAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun licenseGrantAccepter(name: String): LicenseGrantAccepter {
    val builder = LicenseGrantAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
