@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin

import com.pulumi.aws.licensemanager.LicenseGrantAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Accepts a License Manager grant. This allows for sharing licenses with other aws accounts.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.licensemanager.LicenseGrantAccepter;
 * import com.pulumi.aws.licensemanager.LicenseGrantAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new LicenseGrantAccepter("test", LicenseGrantAccepterArgs.builder()
 *             .grantArn("arn:aws:license-manager::123456789012:grant:g-1cf9fba4ba2f42dcab11c686c4b4d329")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_licensemanager_grant_accepter` using the grant arn. For example:
 * ```sh
 *  $ pulumi import aws:licensemanager/licenseGrantAccepter:LicenseGrantAccepter test arn:aws:license-manager::123456789012:grant:g-1cf9fba4ba2f42dcab11c686c4b4d329
 * ```
 * @property grantArn The ARN of the grant to accept.
 */
public data class LicenseGrantAccepterArgs(
    public val grantArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.licensemanager.LicenseGrantAccepterArgs> {
    override fun toJava(): com.pulumi.aws.licensemanager.LicenseGrantAccepterArgs =
        com.pulumi.aws.licensemanager.LicenseGrantAccepterArgs.builder()
            .grantArn(grantArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LicenseGrantAccepterArgs].
 */
@PulumiTagMarker
public class LicenseGrantAccepterArgsBuilder internal constructor() {
    private var grantArn: Output<String>? = null

    /**
     * @param value The ARN of the grant to accept.
     */
    @JvmName("hxqldxmjrrrrjlnb")
    public suspend fun grantArn(`value`: Output<String>) {
        this.grantArn = value
    }

    /**
     * @param value The ARN of the grant to accept.
     */
    @JvmName("dudjtbkmiwhxdxhi")
    public suspend fun grantArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grantArn = mapped
    }

    internal fun build(): LicenseGrantAccepterArgs = LicenseGrantAccepterArgs(
        grantArn = grantArn,
    )
}
