@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin.inputs

import com.pulumi.aws.licensemanager.inputs.GetLicenseGrantsFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the field to filter by, as defined by
 * [the underlying AWS API](https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListReceivedGrants.html#API_ListReceivedGrants_RequestSyntax).
 * For example, if filtering using `ProductSKU`, use:
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const selected = aws.licensemanager.getLicenseGrants({
 *     filters: [{
 *         name: "ProductSKU",
 *         values: [""],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * selected = aws.licensemanager.get_license_grants(filters=[aws.licensemanager.GetLicenseGrantsFilterArgs(
 *     name="ProductSKU",
 *     values=[""],
 * )])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var selected = Aws.LicenseManager.GetLicenseGrants.Invoke(new()
 *     {
 *         Filters = new[]
 *         {
 *             new Aws.LicenseManager.Inputs.GetLicenseGrantsFilterInputArgs
 *             {
 *                 Name = "ProductSKU",
 *                 Values = new[]
 *                 {
 *                     "",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/licensemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := licensemanager.GetLicenseGrants(ctx, &licensemanager.GetLicenseGrantsArgs{
 * 			Filters: []licensemanager.GetLicenseGrantsFilter{
 * 				{
 * 					Name: "ProductSKU",
 * 					Values: []string{
 * 						"",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.licensemanager.LicensemanagerFunctions;
 * import com.pulumi.aws.licensemanager.inputs.GetLicenseGrantsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var selected = LicensemanagerFunctions.getLicenseGrants(GetLicenseGrantsArgs.builder()
 *             .filters(GetLicenseGrantsFilterArgs.builder()
 *                 .name("ProductSKU")
 *                 .values("")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * variables:
 *   selected:
 *     fn::invoke:
 *       Function: aws:licensemanager:getLicenseGrants
 *       Arguments:
 *         filters:
 *           - name: ProductSKU
 *             values:
 *               -
 * ```
 * @property values Set of values that are accepted for the given field.
 */
public data class GetLicenseGrantsFilter(
    public val name: String,
    public val values: List<String>,
) : ConvertibleToJava<com.pulumi.aws.licensemanager.inputs.GetLicenseGrantsFilter> {
    override fun toJava(): com.pulumi.aws.licensemanager.inputs.GetLicenseGrantsFilter =
        com.pulumi.aws.licensemanager.inputs.GetLicenseGrantsFilter.builder()
            .name(name.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetLicenseGrantsFilter].
 */
@PulumiTagMarker
public class GetLicenseGrantsFilterBuilder internal constructor() {
    private var name: String? = null

    private var values: List<String>? = null

    /**
     * @param value Name of the field to filter by, as defined by
     * [the underlying AWS API](https://docs.aws.amazon.com/license-manager/latest/APIReference/API_ListReceivedGrants.html#API_ListReceivedGrants_RequestSyntax).
     * For example, if filtering using `ProductSKU`, use:
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const selected = aws.licensemanager.getLicenseGrants({
     *     filters: [{
     *         name: "ProductSKU",
     *         values: [""],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * selected = aws.licensemanager.get_license_grants(filters=[aws.licensemanager.GetLicenseGrantsFilterArgs(
     *     name="ProductSKU",
     *     values=[""],
     * )])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var selected = Aws.LicenseManager.GetLicenseGrants.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.LicenseManager.Inputs.GetLicenseGrantsFilterInputArgs
     *             {
     *                 Name = "ProductSKU",
     *                 Values = new[]
     *                 {
     *                     "",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/licensemanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := licensemanager.GetLicenseGrants(ctx, &licensemanager.GetLicenseGrantsArgs{
     * 			Filters: []licensemanager.GetLicenseGrantsFilter{
     * 				{
     * 					Name: "ProductSKU",
     * 					Values: []string{
     * 						"",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.licensemanager.LicensemanagerFunctions;
     * import com.pulumi.aws.licensemanager.inputs.GetLicenseGrantsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var selected = LicensemanagerFunctions.getLicenseGrants(GetLicenseGrantsArgs.builder()
     *             .filters(GetLicenseGrantsFilterArgs.builder()
     *                 .name("ProductSKU")
     *                 .values("")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   selected:
     *     fn::invoke:
     *       Function: aws:licensemanager:getLicenseGrants
     *       Arguments:
     *         filters:
     *           - name: ProductSKU
     *             values:
     *               -
     * ```
     */
    @JvmName("cxoiudktluwwrwfs")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Set of values that are accepted for the given field.
     */
    @JvmName("xdlmwjoomqyfbnmo")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values Set of values that are accepted for the given field.
     */
    @JvmName("asagxgilqjuxbtqi")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetLicenseGrantsFilter = GetLicenseGrantsFilter(
        name = name ?: throw PulumiNullFieldException("name"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
