@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin.inputs

import com.pulumi.aws.licensemanager.inputs.GetLicenseGrantsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLicenseGrants.
 * @property filters Custom filter block as described below.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetLicenseGrantsPlainArgs(
    public val filters: List<GetLicenseGrantsFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.licensemanager.inputs.GetLicenseGrantsPlainArgs> {
    override fun toJava(): com.pulumi.aws.licensemanager.inputs.GetLicenseGrantsPlainArgs =
        com.pulumi.aws.licensemanager.inputs.GetLicenseGrantsPlainArgs.builder()
            .filters(
                filters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetLicenseGrantsPlainArgs].
 */
@PulumiTagMarker
public class GetLicenseGrantsPlainArgsBuilder internal constructor() {
    private var filters: List<GetLicenseGrantsFilter>? = null

    /**
     * @param value Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("wwmedwrsfbsmacsq")
    public suspend fun filters(`value`: List<GetLicenseGrantsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("whdnyredutcgahvt")
    public suspend fun filters(argument: List<suspend GetLicenseGrantsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetLicenseGrantsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("vxflnntrmpjcqjlq")
    public suspend fun filters(vararg argument: suspend GetLicenseGrantsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetLicenseGrantsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("fyipotcovunnjcxo")
    public suspend fun filters(argument: suspend GetLicenseGrantsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetLicenseGrantsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("plhhirqwdytjluab")
    public suspend fun filters(vararg values: GetLicenseGrantsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    internal fun build(): GetLicenseGrantsPlainArgs = GetLicenseGrantsPlainArgs(
        filters = filters,
    )
}
