@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin.inputs

import com.pulumi.aws.licensemanager.inputs.GetReceivedLicensesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReceivedLicenses.
 * @property filters Custom filter block as described below.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetReceivedLicensesPlainArgs(
    public val filters: List<GetReceivedLicensesFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.licensemanager.inputs.GetReceivedLicensesPlainArgs> {
    override fun toJava(): com.pulumi.aws.licensemanager.inputs.GetReceivedLicensesPlainArgs =
        com.pulumi.aws.licensemanager.inputs.GetReceivedLicensesPlainArgs.builder()
            .filters(
                filters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetReceivedLicensesPlainArgs].
 */
@PulumiTagMarker
public class GetReceivedLicensesPlainArgsBuilder internal constructor() {
    private var filters: List<GetReceivedLicensesFilter>? = null

    /**
     * @param value Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("upuvdybwbkuperfr")
    public suspend fun filters(`value`: List<GetReceivedLicensesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("evuxjebhdxjfcmtv")
    public suspend fun filters(argument: List<suspend GetReceivedLicensesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetReceivedLicensesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("cxsjosfiivoukuml")
    public suspend fun filters(vararg argument: suspend GetReceivedLicensesFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetReceivedLicensesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("hjerdtjnowbvauqo")
    public suspend fun filters(argument: suspend GetReceivedLicensesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetReceivedLicensesFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("aobyiggtnrgcbfjx")
    public suspend fun filters(vararg values: GetReceivedLicensesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    internal fun build(): GetReceivedLicensesPlainArgs = GetReceivedLicensesPlainArgs(
        filters = filters,
    )
}
