@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getLicenseGrants.
 * @property arns List of all the license grant ARNs found.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 */
public data class GetLicenseGrantsResult(
    public val arns: List<String>,
    public val filters: List<GetLicenseGrantsFilter>? = null,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.licensemanager.outputs.GetLicenseGrantsResult):
            GetLicenseGrantsResult = GetLicenseGrantsResult(
            arns = javaType.arns().map({ args0 -> args0 }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.licensemanager.kotlin.outputs.GetLicenseGrantsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
        )
    }
}
