@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property allowCheckIn Indicates whether check-ins are allowed.
 * @property maxCount Maximum entitlement count. Use if the unit is not None.
 * @property name The key name.
 * @property unit Entitlement unit.
 * @property value The value.
 */
public data class GetReceivedLicenseEntitlement(
    public val allowCheckIn: Boolean,
    public val maxCount: Int,
    public val name: String,
    public val unit: String,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.licensemanager.outputs.GetReceivedLicenseEntitlement):
            GetReceivedLicenseEntitlement = GetReceivedLicenseEntitlement(
            allowCheckIn = javaType.allowCheckIn(),
            maxCount = javaType.maxCount(),
            name = javaType.name(),
            unit = javaType.unit(),
            `value` = javaType.`value`(),
        )
    }
}
