@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.licensemanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property keyFingerprint Issuer key fingerprint.
 * @property name The key name.
 * @property signKey Asymmetric KMS key from AWS Key Management Service. The KMS key must have a key usage of sign and verify, and support the RSASSA-PSS SHA-256 signing algorithm.
 */
public data class GetReceivedLicenseIssuer(
    public val keyFingerprint: String,
    public val name: String,
    public val signKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.licensemanager.outputs.GetReceivedLicenseIssuer):
            GetReceivedLicenseIssuer = GetReceivedLicenseIssuer(
            keyFingerprint = javaType.keyFingerprint(),
            name = javaType.name(),
            signKey = javaType.signKey(),
        )
    }
}
