@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Bucket].
 */
@PulumiTagMarker
public class BucketResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketArgs = BucketArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketArgsBuilder.() -> Unit) {
        val builder = BucketArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Bucket {
        val builtJavaResource = com.pulumi.aws.lightsail.Bucket(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Bucket(builtJavaResource)
    }
}

/**
 * Provides a lightsail bucket.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Bucket;
 * import com.pulumi.aws.lightsail.BucketArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Bucket("test", BucketArgs.builder()
 *             .bundleId("small_1_0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_bucket` using the `name` attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/bucket:Bucket test example-bucket
 * ```
 *
 */
public class Bucket internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.Bucket,
) : KotlinCustomResource(javaResource, BucketMapper) {
    /**
     * The ARN of the lightsail bucket.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The resource Availability Zone. Follows the format us-east-2a (case-sensitive).
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The ID of the bundle to use for the bucket. A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket. Use the [get-bucket-bundles](https://docs.aws.amazon.com/cli/latest/reference/lightsail/get-bucket-bundles.html) cli command to get a list of bundle IDs that you can specify.
     */
    public val bundleId: Output<String>
        get() = javaResource.bundleId().applyValue({ args0 -> args0 })

    /**
     * The timestamp when the bucket was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Force Delete non-empty buckets using `pulumi destroy`. AWS by default will not delete an s3 bucket which is not empty, to prevent losing bucket data and affecting other resources in lightsail. If `force_delete` is set to `true` the bucket will be deleted even when not empty.
     */
    public val forceDelete: Output<Boolean>?
        get() = javaResource.forceDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name for the bucket.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Amazon Web Services Region name.
     */
    public val region: Output<String>
        get() = javaResource.region().applyValue({ args0 -> args0 })

    /**
     * The support code for the resource. Include this code in your email to support when you have questions about a resource in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: Output<String>
        get() = javaResource.supportCode().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })
}

public object BucketMapper : ResourceMapper<Bucket> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.Bucket::class == javaResource::class

    override fun map(javaResource: Resource): Bucket = Bucket(
        javaResource as
            com.pulumi.aws.lightsail.Bucket,
    )
}

/**
 * @see [Bucket].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Bucket].
 */
public suspend fun bucket(name: String, block: suspend BucketResourceBuilder.() -> Unit): Bucket {
    val builder = BucketResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Bucket].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucket(name: String): Bucket {
    val builder = BucketResourceBuilder()
    builder.name(name)
    return builder.build()
}
