@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketAccessKey].
 */
@PulumiTagMarker
public class BucketAccessKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketAccessKeyArgs = BucketAccessKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketAccessKeyArgsBuilder.() -> Unit) {
        val builder = BucketAccessKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketAccessKey {
        val builtJavaResource = com.pulumi.aws.lightsail.BucketAccessKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketAccessKey(builtJavaResource)
    }
}

/**
 * Provides a lightsail bucket access key. This is a set of credentials that allow API requests to be made to the lightsail bucket.
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_bucket_access_key` using the `id` attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/bucketAccessKey:BucketAccessKey test example-bucket,AKIAIOSFODNN7EXAMPLE
 * ```
 *
 */
public class BucketAccessKey internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.BucketAccessKey,
) : KotlinCustomResource(javaResource, BucketAccessKeyMapper) {
    /**
     * The ID of the access key.
     */
    public val accessKeyId: Output<String>
        get() = javaResource.accessKeyId().applyValue({ args0 -> args0 })

    /**
     * The name of the bucket that the new access key will belong to, and grant access to.
     */
    public val bucketName: Output<String>
        get() = javaResource.bucketName().applyValue({ args0 -> args0 })

    /**
     * The timestamp when the access key was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The secret access key used to sign requests. This attribute is not available for imported resources. Note that this will be written to the state file.
     */
    public val secretAccessKey: Output<String>
        get() = javaResource.secretAccessKey().applyValue({ args0 -> args0 })

    /**
     * The status of the access key.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object BucketAccessKeyMapper : ResourceMapper<BucketAccessKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.BucketAccessKey::class == javaResource::class

    override fun map(javaResource: Resource): BucketAccessKey = BucketAccessKey(
        javaResource as
            com.pulumi.aws.lightsail.BucketAccessKey,
    )
}

/**
 * @see [BucketAccessKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketAccessKey].
 */
public suspend fun bucketAccessKey(
    name: String,
    block: suspend BucketAccessKeyResourceBuilder.() -> Unit,
): BucketAccessKey {
    val builder = BucketAccessKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketAccessKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketAccessKey(name: String): BucketAccessKey {
    val builder = BucketAccessKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
