@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.BucketAccessKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a lightsail bucket access key. This is a set of credentials that allow API requests to be made to the lightsail bucket.
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_bucket_access_key` using the `id` attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/bucketAccessKey:BucketAccessKey test example-bucket,AKIAIOSFODNN7EXAMPLE
 * ```
 * @property bucketName The name of the bucket that the new access key will belong to, and grant access to.
 */
public data class BucketAccessKeyArgs(
    public val bucketName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.BucketAccessKeyArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.BucketAccessKeyArgs =
        com.pulumi.aws.lightsail.BucketAccessKeyArgs.builder()
            .bucketName(bucketName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketAccessKeyArgs].
 */
@PulumiTagMarker
public class BucketAccessKeyArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    /**
     * @param value The name of the bucket that the new access key will belong to, and grant access to.
     */
    @JvmName("vsinywsfkkqlecgd")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The name of the bucket that the new access key will belong to, and grant access to.
     */
    @JvmName("bbvaqxexlhndpsjj")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    internal fun build(): BucketAccessKeyArgs = BucketAccessKeyArgs(
        bucketName = bucketName,
    )
}
