@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BucketResourceAccess].
 */
@PulumiTagMarker
public class BucketResourceAccessResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BucketResourceAccessArgs = BucketResourceAccessArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BucketResourceAccessArgsBuilder.() -> Unit) {
        val builder = BucketResourceAccessArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BucketResourceAccess {
        val builtJavaResource = com.pulumi.aws.lightsail.BucketResourceAccess(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BucketResourceAccess(builtJavaResource)
    }
}

/**
 * Provides a lightsail resource access to a bucket.
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_bucket_resource_access` using the `id` attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/bucketResourceAccess:BucketResourceAccess test example-bucket,example-instance
 * ```
 *
 */
public class BucketResourceAccess internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.BucketResourceAccess,
) : KotlinCustomResource(javaResource, BucketResourceAccessMapper) {
    /**
     * The name of the bucket to grant access to.
     */
    public val bucketName: Output<String>
        get() = javaResource.bucketName().applyValue({ args0 -> args0 })

    /**
     * The name of the resource to be granted bucket access.
     */
    public val resourceName: Output<String>
        get() = javaResource.resourceName().applyValue({ args0 -> args0 })
}

public object BucketResourceAccessMapper : ResourceMapper<BucketResourceAccess> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.BucketResourceAccess::class == javaResource::class

    override fun map(javaResource: Resource): BucketResourceAccess = BucketResourceAccess(
        javaResource
            as com.pulumi.aws.lightsail.BucketResourceAccess,
    )
}

/**
 * @see [BucketResourceAccess].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BucketResourceAccess].
 */
public suspend fun bucketResourceAccess(
    name: String,
    block: suspend BucketResourceAccessResourceBuilder.() -> Unit,
): BucketResourceAccess {
    val builder = BucketResourceAccessResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BucketResourceAccess].
 * @param name The _unique_ name of the resulting resource.
 */
public fun bucketResourceAccess(name: String): BucketResourceAccess {
    val builder = BucketResourceAccessResourceBuilder()
    builder.name(name)
    return builder.build()
}
