@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.BucketResourceAccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a lightsail resource access to a bucket.
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_bucket_resource_access` using the `id` attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/bucketResourceAccess:BucketResourceAccess test example-bucket,example-instance
 * ```
 * @property bucketName The name of the bucket to grant access to.
 * @property resourceName The name of the resource to be granted bucket access.
 */
public data class BucketResourceAccessArgs(
    public val bucketName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.BucketResourceAccessArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.BucketResourceAccessArgs =
        com.pulumi.aws.lightsail.BucketResourceAccessArgs.builder()
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketResourceAccessArgs].
 */
@PulumiTagMarker
public class BucketResourceAccessArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value The name of the bucket to grant access to.
     */
    @JvmName("rdnmgaqyckgxylqx")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value The name of the resource to be granted bucket access.
     */
    @JvmName("ijjnacbfhhgdudie")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The name of the bucket to grant access to.
     */
    @JvmName("dtpvuajyqmspteff")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value The name of the resource to be granted bucket access.
     */
    @JvmName("dariugngrbufevea")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): BucketResourceAccessArgs = BucketResourceAccessArgs(
        bucketName = bucketName,
        resourceName = resourceName,
    )
}
