@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.kotlin.outputs.CertificateDomainValidationOption
import com.pulumi.aws.lightsail.kotlin.outputs.CertificateDomainValidationOption.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Certificate].
 */
@PulumiTagMarker
public class CertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CertificateArgs = CertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CertificateArgsBuilder.() -> Unit) {
        val builder = CertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Certificate {
        val builtJavaResource = com.pulumi.aws.lightsail.Certificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Certificate(builtJavaResource)
    }
}

/**
 * Provides a lightsail certificate.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Certificate;
 * import com.pulumi.aws.lightsail.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Certificate("test", CertificateArgs.builder()
 *             .domainName("testdomain.com")
 *             .subjectAlternativeNames("www.testdomain.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_certificate` using the certificate name. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/certificate:Certificate test CertificateName
 * ```
 *
 */
public class Certificate internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.Certificate,
) : KotlinCustomResource(javaResource, CertificateMapper) {
    /**
     * The ARN of the lightsail certificate.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The timestamp when the instance was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * A domain name for which the certificate should be issued.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Set of domain validation objects which can be used to complete certificate validation. Can have more than one element, e.g., if SANs are defined.
     */
    public val domainValidationOptions: Output<List<CertificateDomainValidationOption>>
        get() = javaResource.domainValidationOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The name of the Lightsail load balancer.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Set of domains that should be SANs in the issued certificate. `domain_name` attribute is automatically added as a Subject Alternative Name.
     */
    public val subjectAlternativeNames: Output<List<String>>
        get() = javaResource.subjectAlternativeNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object CertificateMapper : ResourceMapper<Certificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.Certificate::class == javaResource::class

    override fun map(javaResource: Resource): Certificate = Certificate(
        javaResource as
            com.pulumi.aws.lightsail.Certificate,
    )
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Certificate].
 */
public suspend fun certificate(name: String, block: suspend CertificateResourceBuilder.() -> Unit):
    Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun certificate(name: String): Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
