@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.CertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a lightsail certificate.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Certificate;
 * import com.pulumi.aws.lightsail.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Certificate("test", CertificateArgs.builder()
 *             .domainName("testdomain.com")
 *             .subjectAlternativeNames("www.testdomain.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_certificate` using the certificate name. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/certificate:Certificate test CertificateName
 * ```
 * @property domainName A domain name for which the certificate should be issued.
 * @property name The name of the Lightsail load balancer.
 * @property subjectAlternativeNames Set of domains that should be SANs in the issued certificate. `domain_name` attribute is automatically added as a Subject Alternative Name.
 * @property tags A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class CertificateArgs(
    public val domainName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val subjectAlternativeNames: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.CertificateArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.CertificateArgs =
        com.pulumi.aws.lightsail.CertificateArgs.builder()
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .subjectAlternativeNames(
                subjectAlternativeNames?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CertificateArgs].
 */
@PulumiTagMarker
public class CertificateArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var name: Output<String>? = null

    private var subjectAlternativeNames: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A domain name for which the certificate should be issued.
     */
    @JvmName("glpckykfihaoolee")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The name of the Lightsail load balancer.
     */
    @JvmName("owtoxfhxoxosvcwy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Set of domains that should be SANs in the issued certificate. `domain_name` attribute is automatically added as a Subject Alternative Name.
     */
    @JvmName("lxniksiaewxpgsyy")
    public suspend fun subjectAlternativeNames(`value`: Output<List<String>>) {
        this.subjectAlternativeNames = value
    }

    @JvmName("ovjorgyuauxqmwld")
    public suspend fun subjectAlternativeNames(vararg values: Output<String>) {
        this.subjectAlternativeNames = Output.all(values.asList())
    }

    /**
     * @param values Set of domains that should be SANs in the issued certificate. `domain_name` attribute is automatically added as a Subject Alternative Name.
     */
    @JvmName("jpettdwdwukrtdgd")
    public suspend fun subjectAlternativeNames(values: List<Output<String>>) {
        this.subjectAlternativeNames = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ujtxjxvtjgyqibcy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A domain name for which the certificate should be issued.
     */
    @JvmName("krkjlkhqbxnfnqme")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The name of the Lightsail load balancer.
     */
    @JvmName("rcrgjokxflowlsqb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Set of domains that should be SANs in the issued certificate. `domain_name` attribute is automatically added as a Subject Alternative Name.
     */
    @JvmName("tismwyovdedsfqub")
    public suspend fun subjectAlternativeNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param values Set of domains that should be SANs in the issued certificate. `domain_name` attribute is automatically added as a Subject Alternative Name.
     */
    @JvmName("opmpbubdfgxtwgst")
    public suspend fun subjectAlternativeNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subjectAlternativeNames = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("agjfdnqsflfrsojs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gkorrkitkhgdtbpl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CertificateArgs = CertificateArgs(
        domainName = domainName,
        name = name,
        subjectAlternativeNames = subjectAlternativeNames,
        tags = tags,
    )
}
