@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.kotlin.outputs.ContainerServicePrivateRegistryAccess
import com.pulumi.aws.lightsail.kotlin.outputs.ContainerServicePublicDomainNames
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.lightsail.kotlin.outputs.ContainerServicePrivateRegistryAccess.Companion.toKotlin as containerServicePrivateRegistryAccessToKotlin
import com.pulumi.aws.lightsail.kotlin.outputs.ContainerServicePublicDomainNames.Companion.toKotlin as containerServicePublicDomainNamesToKotlin

/**
 * Builder for [ContainerService].
 */
@PulumiTagMarker
public class ContainerServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContainerServiceArgs = ContainerServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContainerServiceArgsBuilder.() -> Unit) {
        val builder = ContainerServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ContainerService {
        val builtJavaResource = com.pulumi.aws.lightsail.ContainerService(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ContainerService(builtJavaResource)
    }
}

/**
 * An Amazon Lightsail container service is a highly scalable compute and networking resource on which you can deploy, run,
 * and manage containers. For more information, see
 * [Container services in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-services).
 * > **Note:** For more information about the AWS Regions in which you can create Amazon Lightsail container services,
 * see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail).
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.ContainerService;
 * import com.pulumi.aws.lightsail.ContainerServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myContainerService = new ContainerService("myContainerService", ContainerServiceArgs.builder()
 *             .isDisabled(false)
 *             .power("nano")
 *             .scale(1)
 *             .tags(Map.ofEntries(
 *                 Map.entry("foo1", "bar1"),
 *                 Map.entry("foo2", "")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Public Domain Names
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.ContainerService;
 * import com.pulumi.aws.lightsail.ContainerServiceArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServicePublicDomainNamesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myContainerService = new ContainerService("myContainerService", ContainerServiceArgs.builder()
 *             .publicDomainNames(ContainerServicePublicDomainNamesArgs.builder()
 *                 .certificates(ContainerServicePublicDomainNamesCertificateArgs.builder()
 *                     .certificateName("example-certificate")
 *                     .domainNames("www.example.com")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Private Registry Access
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.ContainerService;
 * import com.pulumi.aws.lightsail.ContainerServiceArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.ecr.RepositoryPolicy;
 * import com.pulumi.aws.ecr.RepositoryPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultContainerService = new ContainerService("defaultContainerService", ContainerServiceArgs.builder()
 *             .privateRegistryAccess(ContainerServicePrivateRegistryAccessArgs.builder()
 *                 .ecrImagePullerRole(ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs.builder()
 *                     .isActive(true)
 *                     .build())
 *                 .build())
 *             .build());
 *         final var defaultPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers(defaultContainerService.privateRegistryAccess().applyValue(privateRegistryAccess -> privateRegistryAccess.ecrImagePullerRole().principalArn()))
 *                     .build())
 *                 .actions(
 *                     "ecr:BatchGetImage",
 *                     "ecr:GetDownloadUrlForLayer")
 *                 .build())
 *             .build());
 *         var defaultRepositoryPolicy = new RepositoryPolicy("defaultRepositoryPolicy", RepositoryPolicyArgs.builder()
 *             .repository(aws_ecr_repository.default().name())
 *             .policy(defaultPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(defaultPolicyDocument -> defaultPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Lightsail Container Service using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/containerService:ContainerService my_container_service container-service-1
 * ```
 *
 */
public class ContainerService internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.ContainerService,
) : KotlinCustomResource(javaResource, ContainerServiceMapper) {
    /**
     * The Amazon Resource Name (ARN) of the container service.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Availability Zone. Follows the format us-east-2a (case-sensitive).
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * A Boolean value indicating whether the container service is disabled. Defaults to `false`.
     */
    public val isDisabled: Output<Boolean>?
        get() = javaResource.isDisabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name for the container service. Names must be of length 1 to 63, and be
     * unique within each AWS Region in your Lightsail account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The power specification for the container service. The power specifies the amount of memory,
     * the number of vCPUs, and the monthly price of each node of the container service.
     * Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
     */
    public val power: Output<String>
        get() = javaResource.power().applyValue({ args0 -> args0 })

    /**
     * The ID of the power of the container service.
     */
    public val powerId: Output<String>
        get() = javaResource.powerId().applyValue({ args0 -> args0 })

    /**
     * The principal ARN of the container service. The principal ARN can be used to create a trust
     * relationship between your standard AWS account and your Lightsail container service. This allows you to give your
     * service permission to access resources in your standard AWS account.
     */
    public val principalArn: Output<String>
        get() = javaResource.principalArn().applyValue({ args0 -> args0 })

    /**
     * The private domain name of the container service. The private domain name is accessible only
     * by other resources within the default virtual private cloud (VPC) of your Lightsail account.
     */
    public val privateDomainName: Output<String>
        get() = javaResource.privateDomainName().applyValue({ args0 -> args0 })

    /**
     * An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
     */
    public val privateRegistryAccess: Output<ContainerServicePrivateRegistryAccess>
        get() = javaResource.privateRegistryAccess().applyValue({ args0 ->
            args0.let({ args0 ->
                containerServicePrivateRegistryAccessToKotlin(args0)
            })
        })

    /**
     * The public domain names to use with the container service, such as example.com
     * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
     * specify are used when you create a deployment with a container configured as the public endpoint of your container
     * service. If you don't specify public domain names, then you can use the default domain of the container service.
     * Defined below.
     */
    public val publicDomainNames: Output<ContainerServicePublicDomainNames>?
        get() = javaResource.publicDomainNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> containerServicePublicDomainNamesToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Lightsail resource type of the container service (i.e., ContainerService).
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * The scale specification for the container service. The scale specifies the allocated compute
     * nodes of the container service.
     */
    public val scale: Output<Int>
        get() = javaResource.scale().applyValue({ args0 -> args0 })

    /**
     * The current state of the container service.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Map of container service tags. To tag at launch, specify the tags in the Launch Template. If
     * configured with a provider
     * `default_tags` configuration block
     * present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider
     * `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The publicly accessible URL of the container service. If no public endpoint is specified in the
     * currentDeployment, this URL returns a 404 response.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })
}

public object ContainerServiceMapper : ResourceMapper<ContainerService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.ContainerService::class == javaResource::class

    override fun map(javaResource: Resource): ContainerService = ContainerService(
        javaResource as
            com.pulumi.aws.lightsail.ContainerService,
    )
}

/**
 * @see [ContainerService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContainerService].
 */
public suspend fun containerService(
    name: String,
    block: suspend ContainerServiceResourceBuilder.() -> Unit,
): ContainerService {
    val builder = ContainerServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContainerService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun containerService(name: String): ContainerService {
    val builder = ContainerServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
