@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.ContainerServiceArgs.builder
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServicePrivateRegistryAccessArgs
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServicePrivateRegistryAccessArgsBuilder
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServicePublicDomainNamesArgs
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServicePublicDomainNamesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Amazon Lightsail container service is a highly scalable compute and networking resource on which you can deploy, run,
 * and manage containers. For more information, see
 * [Container services in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-services).
 * > **Note:** For more information about the AWS Regions in which you can create Amazon Lightsail container services,
 * see ["Regions and Availability Zones in Amazon Lightsail"](https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail).
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.ContainerService;
 * import com.pulumi.aws.lightsail.ContainerServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myContainerService = new ContainerService("myContainerService", ContainerServiceArgs.builder()
 *             .isDisabled(false)
 *             .power("nano")
 *             .scale(1)
 *             .tags(Map.ofEntries(
 *                 Map.entry("foo1", "bar1"),
 *                 Map.entry("foo2", "")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Public Domain Names
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.ContainerService;
 * import com.pulumi.aws.lightsail.ContainerServiceArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServicePublicDomainNamesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myContainerService = new ContainerService("myContainerService", ContainerServiceArgs.builder()
 *             .publicDomainNames(ContainerServicePublicDomainNamesArgs.builder()
 *                 .certificates(ContainerServicePublicDomainNamesCertificateArgs.builder()
 *                     .certificateName("example-certificate")
 *                     .domainNames("www.example.com")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Private Registry Access
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.ContainerService;
 * import com.pulumi.aws.lightsail.ContainerServiceArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.ecr.RepositoryPolicy;
 * import com.pulumi.aws.ecr.RepositoryPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultContainerService = new ContainerService("defaultContainerService", ContainerServiceArgs.builder()
 *             .privateRegistryAccess(ContainerServicePrivateRegistryAccessArgs.builder()
 *                 .ecrImagePullerRole(ContainerServicePrivateRegistryAccessEcrImagePullerRoleArgs.builder()
 *                     .isActive(true)
 *                     .build())
 *                 .build())
 *             .build());
 *         final var defaultPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers(defaultContainerService.privateRegistryAccess().applyValue(privateRegistryAccess -> privateRegistryAccess.ecrImagePullerRole().principalArn()))
 *                     .build())
 *                 .actions(
 *                     "ecr:BatchGetImage",
 *                     "ecr:GetDownloadUrlForLayer")
 *                 .build())
 *             .build());
 *         var defaultRepositoryPolicy = new RepositoryPolicy("defaultRepositoryPolicy", RepositoryPolicyArgs.builder()
 *             .repository(aws_ecr_repository.default().name())
 *             .policy(defaultPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(defaultPolicyDocument -> defaultPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Lightsail Container Service using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/containerService:ContainerService my_container_service container-service-1
 * ```
 * @property isDisabled A Boolean value indicating whether the container service is disabled. Defaults to `false`.
 * @property name The name for the container service. Names must be of length 1 to 63, and be
 * unique within each AWS Region in your Lightsail account.
 * @property power The power specification for the container service. The power specifies the amount of memory,
 * the number of vCPUs, and the monthly price of each node of the container service.
 * Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
 * @property privateRegistryAccess An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
 * @property publicDomainNames The public domain names to use with the container service, such as example.com
 * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
 * specify are used when you create a deployment with a container configured as the public endpoint of your container
 * service. If you don't specify public domain names, then you can use the default domain of the container service.
 * Defined below.
 * @property scale The scale specification for the container service. The scale specifies the allocated compute
 * nodes of the container service.
 * @property tags Map of container service tags. To tag at launch, specify the tags in the Launch Template. If
 * configured with a provider
 * `default_tags` configuration block
 * present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ContainerServiceArgs(
    public val isDisabled: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val power: Output<String>? = null,
    public val privateRegistryAccess: Output<ContainerServicePrivateRegistryAccessArgs>? = null,
    public val publicDomainNames: Output<ContainerServicePublicDomainNamesArgs>? = null,
    public val scale: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.ContainerServiceArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.ContainerServiceArgs =
        com.pulumi.aws.lightsail.ContainerServiceArgs.builder()
            .isDisabled(isDisabled?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .power(power?.applyValue({ args0 -> args0 }))
            .privateRegistryAccess(
                privateRegistryAccess?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .publicDomainNames(publicDomainNames?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scale(scale?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ContainerServiceArgs].
 */
@PulumiTagMarker
public class ContainerServiceArgsBuilder internal constructor() {
    private var isDisabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var power: Output<String>? = null

    private var privateRegistryAccess: Output<ContainerServicePrivateRegistryAccessArgs>? = null

    private var publicDomainNames: Output<ContainerServicePublicDomainNamesArgs>? = null

    private var scale: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A Boolean value indicating whether the container service is disabled. Defaults to `false`.
     */
    @JvmName("syxmwoxhsjfaound")
    public suspend fun isDisabled(`value`: Output<Boolean>) {
        this.isDisabled = value
    }

    /**
     * @param value The name for the container service. Names must be of length 1 to 63, and be
     * unique within each AWS Region in your Lightsail account.
     */
    @JvmName("ukmsxqqjnfdiwfyd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The power specification for the container service. The power specifies the amount of memory,
     * the number of vCPUs, and the monthly price of each node of the container service.
     * Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
     */
    @JvmName("oitcqrmpvjakfwsw")
    public suspend fun power(`value`: Output<String>) {
        this.power = value
    }

    /**
     * @param value An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
     */
    @JvmName("kopalvchjfdwxpii")
    public suspend
    fun privateRegistryAccess(`value`: Output<ContainerServicePrivateRegistryAccessArgs>) {
        this.privateRegistryAccess = value
    }

    /**
     * @param value The public domain names to use with the container service, such as example.com
     * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
     * specify are used when you create a deployment with a container configured as the public endpoint of your container
     * service. If you don't specify public domain names, then you can use the default domain of the container service.
     * Defined below.
     */
    @JvmName("ewpwlrvgdiocbfyj")
    public suspend fun publicDomainNames(`value`: Output<ContainerServicePublicDomainNamesArgs>) {
        this.publicDomainNames = value
    }

    /**
     * @param value The scale specification for the container service. The scale specifies the allocated compute
     * nodes of the container service.
     */
    @JvmName("kfmwfhscdaipkncd")
    public suspend fun scale(`value`: Output<Int>) {
        this.scale = value
    }

    /**
     * @param value Map of container service tags. To tag at launch, specify the tags in the Launch Template. If
     * configured with a provider
     * `default_tags` configuration block
     * present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("orcakyqcnxaykoni")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A Boolean value indicating whether the container service is disabled. Defaults to `false`.
     */
    @JvmName("nmafyjsxguyoomcx")
    public suspend fun isDisabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDisabled = mapped
    }

    /**
     * @param value The name for the container service. Names must be of length 1 to 63, and be
     * unique within each AWS Region in your Lightsail account.
     */
    @JvmName("xxdsigflthmfltaj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The power specification for the container service. The power specifies the amount of memory,
     * the number of vCPUs, and the monthly price of each node of the container service.
     * Possible values: `nano`, `micro`, `small`, `medium`, `large`, `xlarge`.
     */
    @JvmName("rskrdkgjsbpvnpdi")
    public suspend fun power(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.power = mapped
    }

    /**
     * @param value An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
     */
    @JvmName("ftuktvcncljmqabl")
    public suspend fun privateRegistryAccess(`value`: ContainerServicePrivateRegistryAccessArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateRegistryAccess = mapped
    }

    /**
     * @param argument An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories. See Private Registry Access below for more details.
     */
    @JvmName("ibecernomlmvexue")
    public suspend
    fun privateRegistryAccess(argument: suspend ContainerServicePrivateRegistryAccessArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerServicePrivateRegistryAccessArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateRegistryAccess = mapped
    }

    /**
     * @param value The public domain names to use with the container service, such as example.com
     * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
     * specify are used when you create a deployment with a container configured as the public endpoint of your container
     * service. If you don't specify public domain names, then you can use the default domain of the container service.
     * Defined below.
     */
    @JvmName("xafabxrnbwbgaokg")
    public suspend fun publicDomainNames(`value`: ContainerServicePublicDomainNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicDomainNames = mapped
    }

    /**
     * @param argument The public domain names to use with the container service, such as example.com
     * and www.example.com. You can specify up to four public domain names for a container service. The domain names that you
     * specify are used when you create a deployment with a container configured as the public endpoint of your container
     * service. If you don't specify public domain names, then you can use the default domain of the container service.
     * Defined below.
     */
    @JvmName("rnhnnuutxpowbwpx")
    public suspend
    fun publicDomainNames(argument: suspend ContainerServicePublicDomainNamesArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerServicePublicDomainNamesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.publicDomainNames = mapped
    }

    /**
     * @param value The scale specification for the container service. The scale specifies the allocated compute
     * nodes of the container service.
     */
    @JvmName("rlvaawtecabfrrup")
    public suspend fun scale(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scale = mapped
    }

    /**
     * @param value Map of container service tags. To tag at launch, specify the tags in the Launch Template. If
     * configured with a provider
     * `default_tags` configuration block
     * present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rskmxumxitytumsw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of container service tags. To tag at launch, specify the tags in the Launch Template. If
     * configured with a provider
     * `default_tags` configuration block
     * present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ibyeibromxpqifug")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ContainerServiceArgs = ContainerServiceArgs(
        isDisabled = isDisabled,
        name = name,
        power = power,
        privateRegistryAccess = privateRegistryAccess,
        publicDomainNames = publicDomainNames,
        scale = scale,
        tags = tags,
    )
}
