@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.kotlin.outputs.ContainerServiceDeploymentVersionContainer
import com.pulumi.aws.lightsail.kotlin.outputs.ContainerServiceDeploymentVersionPublicEndpoint
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.lightsail.kotlin.outputs.ContainerServiceDeploymentVersionContainer.Companion.toKotlin as containerServiceDeploymentVersionContainerToKotlin
import com.pulumi.aws.lightsail.kotlin.outputs.ContainerServiceDeploymentVersionPublicEndpoint.Companion.toKotlin as containerServiceDeploymentVersionPublicEndpointToKotlin

/**
 * Builder for [ContainerServiceDeploymentVersion].
 */
@PulumiTagMarker
public class ContainerServiceDeploymentVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContainerServiceDeploymentVersionArgs = ContainerServiceDeploymentVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContainerServiceDeploymentVersionArgsBuilder.() -> Unit) {
        val builder = ContainerServiceDeploymentVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ContainerServiceDeploymentVersion {
        val builtJavaResource =
            com.pulumi.aws.lightsail.ContainerServiceDeploymentVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ContainerServiceDeploymentVersion(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a deployment version for your Amazon Lightsail container service.
 * > **NOTE:** The Amazon Lightsail container service must be enabled to create a deployment.
 * > **NOTE:** This resource allows you to manage an Amazon Lightsail container service deployment version but the provider cannot destroy it. Removing this resource from your configuration will remove it from your statefile.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.ContainerServiceDeploymentVersion;
 * import com.pulumi.aws.lightsail.ContainerServiceDeploymentVersionArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionContainerArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionPublicEndpointArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContainerServiceDeploymentVersion("example", ContainerServiceDeploymentVersionArgs.builder()
 *             .containers(ContainerServiceDeploymentVersionContainerArgs.builder()
 *                 .containerName("hello-world")
 *                 .image("amazon/amazon-lightsail:hello-world")
 *                 .commands()
 *                 .environment(Map.of("MY_ENVIRONMENT_VARIABLE", "my_value"))
 *                 .ports(Map.of("80", "HTTP"))
 *                 .build())
 *             .publicEndpoint(ContainerServiceDeploymentVersionPublicEndpointArgs.builder()
 *                 .containerName("hello-world")
 *                 .containerPort(80)
 *                 .healthCheck(ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs.builder()
 *                     .healthyThreshold(2)
 *                     .unhealthyThreshold(2)
 *                     .timeoutSeconds(2)
 *                     .intervalSeconds(5)
 *                     .path("/")
 *                     .successCodes("200-499")
 *                     .build())
 *                 .build())
 *             .serviceName(aws_lightsail_container_service.example().name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Lightsail Container Service Deployment Version using the `service_name` and `version` separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:lightsail/containerServiceDeploymentVersion:ContainerServiceDeploymentVersion example container-service-1/1
 * ```
 *
 */
public class ContainerServiceDeploymentVersion internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.ContainerServiceDeploymentVersion,
) : KotlinCustomResource(javaResource, ContainerServiceDeploymentVersionMapper) {
    /**
     * A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
     */
    public val containers: Output<List<ContainerServiceDeploymentVersionContainer>>
        get() = javaResource.containers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    containerServiceDeploymentVersionContainerToKotlin(args0)
                })
            })
        })

    /**
     * The timestamp when the deployment was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * A configuration block that describes the settings of the public endpoint for the container service. Detailed below.
     */
    public val publicEndpoint: Output<ContainerServiceDeploymentVersionPublicEndpoint>?
        get() = javaResource.publicEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    containerServiceDeploymentVersionPublicEndpointToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name for the container service.
     */
    public val serviceName: Output<String>
        get() = javaResource.serviceName().applyValue({ args0 -> args0 })

    /**
     * The current state of the container service.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The version number of the deployment.
     */
    public val version: Output<Int>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object ContainerServiceDeploymentVersionMapper :
    ResourceMapper<ContainerServiceDeploymentVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.ContainerServiceDeploymentVersion::class == javaResource::class

    override fun map(javaResource: Resource): ContainerServiceDeploymentVersion =
        ContainerServiceDeploymentVersion(
            javaResource as
                com.pulumi.aws.lightsail.ContainerServiceDeploymentVersion,
        )
}

/**
 * @see [ContainerServiceDeploymentVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContainerServiceDeploymentVersion].
 */
public suspend fun containerServiceDeploymentVersion(
    name: String,
    block: suspend ContainerServiceDeploymentVersionResourceBuilder.() -> Unit,
):
    ContainerServiceDeploymentVersion {
    val builder = ContainerServiceDeploymentVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContainerServiceDeploymentVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun containerServiceDeploymentVersion(name: String): ContainerServiceDeploymentVersion {
    val builder = ContainerServiceDeploymentVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
