@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.ContainerServiceDeploymentVersionArgs.builder
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServiceDeploymentVersionContainerArgs
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServiceDeploymentVersionContainerArgsBuilder
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServiceDeploymentVersionPublicEndpointArgs
import com.pulumi.aws.lightsail.kotlin.inputs.ContainerServiceDeploymentVersionPublicEndpointArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a deployment version for your Amazon Lightsail container service.
 * > **NOTE:** The Amazon Lightsail container service must be enabled to create a deployment.
 * > **NOTE:** This resource allows you to manage an Amazon Lightsail container service deployment version but the provider cannot destroy it. Removing this resource from your configuration will remove it from your statefile.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.ContainerServiceDeploymentVersion;
 * import com.pulumi.aws.lightsail.ContainerServiceDeploymentVersionArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionContainerArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionPublicEndpointArgs;
 * import com.pulumi.aws.lightsail.inputs.ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContainerServiceDeploymentVersion("example", ContainerServiceDeploymentVersionArgs.builder()
 *             .containers(ContainerServiceDeploymentVersionContainerArgs.builder()
 *                 .containerName("hello-world")
 *                 .image("amazon/amazon-lightsail:hello-world")
 *                 .commands()
 *                 .environment(Map.of("MY_ENVIRONMENT_VARIABLE", "my_value"))
 *                 .ports(Map.of("80", "HTTP"))
 *                 .build())
 *             .publicEndpoint(ContainerServiceDeploymentVersionPublicEndpointArgs.builder()
 *                 .containerName("hello-world")
 *                 .containerPort(80)
 *                 .healthCheck(ContainerServiceDeploymentVersionPublicEndpointHealthCheckArgs.builder()
 *                     .healthyThreshold(2)
 *                     .unhealthyThreshold(2)
 *                     .timeoutSeconds(2)
 *                     .intervalSeconds(5)
 *                     .path("/")
 *                     .successCodes("200-499")
 *                     .build())
 *                 .build())
 *             .serviceName(aws_lightsail_container_service.example().name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Lightsail Container Service Deployment Version using the `service_name` and `version` separated by a slash (`/`). For example:
 * ```sh
 *  $ pulumi import aws:lightsail/containerServiceDeploymentVersion:ContainerServiceDeploymentVersion example container-service-1/1
 * ```
 * @property containers A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
 * @property publicEndpoint A configuration block that describes the settings of the public endpoint for the container service. Detailed below.
 * @property serviceName The name for the container service.
 */
public data class ContainerServiceDeploymentVersionArgs(
    public val containers: Output<List<ContainerServiceDeploymentVersionContainerArgs>>? = null,
    public val publicEndpoint: Output<ContainerServiceDeploymentVersionPublicEndpointArgs>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.ContainerServiceDeploymentVersionArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.ContainerServiceDeploymentVersionArgs =
        com.pulumi.aws.lightsail.ContainerServiceDeploymentVersionArgs.builder()
            .containers(
                containers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .publicEndpoint(publicEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerServiceDeploymentVersionArgs].
 */
@PulumiTagMarker
public class ContainerServiceDeploymentVersionArgsBuilder internal constructor() {
    private var containers: Output<List<ContainerServiceDeploymentVersionContainerArgs>>? = null

    private var publicEndpoint: Output<ContainerServiceDeploymentVersionPublicEndpointArgs>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
     */
    @JvmName("ytytysefkevdgxga")
    public suspend
    fun containers(`value`: Output<List<ContainerServiceDeploymentVersionContainerArgs>>) {
        this.containers = value
    }

    @JvmName("pxolideufruoljwx")
    public suspend fun containers(
        vararg
        values: Output<ContainerServiceDeploymentVersionContainerArgs>,
    ) {
        this.containers = Output.all(values.asList())
    }

    /**
     * @param values A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
     */
    @JvmName("pnadotuliplfjull")
    public suspend
    fun containers(values: List<Output<ContainerServiceDeploymentVersionContainerArgs>>) {
        this.containers = Output.all(values)
    }

    /**
     * @param value A configuration block that describes the settings of the public endpoint for the container service. Detailed below.
     */
    @JvmName("ugfbllkibjysvyhx")
    public suspend
    fun publicEndpoint(`value`: Output<ContainerServiceDeploymentVersionPublicEndpointArgs>) {
        this.publicEndpoint = value
    }

    /**
     * @param value The name for the container service.
     */
    @JvmName("gnsyocwbsogviijo")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
     */
    @JvmName("bvbbtjbknqbfkcpc")
    public suspend fun containers(`value`: List<ContainerServiceDeploymentVersionContainerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param argument A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
     */
    @JvmName("jxbtssxnarswmksx")
    public suspend
    fun containers(argument: List<suspend ContainerServiceDeploymentVersionContainerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerServiceDeploymentVersionContainerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
     */
    @JvmName("xexufbugjkhgahkh")
    public suspend fun containers(
        vararg
        argument: suspend ContainerServiceDeploymentVersionContainerArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ContainerServiceDeploymentVersionContainerArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param argument A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
     */
    @JvmName("gvhrkksrjtnpmpoy")
    public suspend
    fun containers(argument: suspend ContainerServiceDeploymentVersionContainerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerServiceDeploymentVersionContainerArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.containers = mapped
    }

    /**
     * @param values A set of configuration blocks that describe the settings of the containers that will be launched on the container service. Maximum of 53. Detailed below.
     */
    @JvmName("rdbjaejruylbbkhh")
    public suspend fun containers(vararg values: ContainerServiceDeploymentVersionContainerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containers = mapped
    }

    /**
     * @param value A configuration block that describes the settings of the public endpoint for the container service. Detailed below.
     */
    @JvmName("fymtndhpgmqxxege")
    public suspend fun publicEndpoint(`value`: ContainerServiceDeploymentVersionPublicEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicEndpoint = mapped
    }

    /**
     * @param argument A configuration block that describes the settings of the public endpoint for the container service. Detailed below.
     */
    @JvmName("wgwugfhmgqsgerjk")
    public suspend
    fun publicEndpoint(argument: suspend ContainerServiceDeploymentVersionPublicEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerServiceDeploymentVersionPublicEndpointArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.publicEndpoint = mapped
    }

    /**
     * @param value The name for the container service.
     */
    @JvmName("xlxusqiqhgtjibwx")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ContainerServiceDeploymentVersionArgs =
        ContainerServiceDeploymentVersionArgs(
            containers = containers,
            publicEndpoint = publicEndpoint,
            serviceName = serviceName,
        )
}
