@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Database].
 */
@PulumiTagMarker
public class DatabaseResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatabaseArgs = DatabaseArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatabaseArgsBuilder.() -> Unit) {
        val builder = DatabaseArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Database {
        val builtJavaResource = com.pulumi.aws.lightsail.Database(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Database(builtJavaResource)
    }
}

/**
 * Provides a Lightsail Database. Amazon Lightsail is a service to provide easy virtual private servers
 * with custom software already setup. See [What is Amazon Lightsail?](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/what-is-amazon-lightsail)
 * for more information.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones"](https://aws.amazon.com/about-aws/global-infrastructure/regional-product-services/) for more details
 * ## Example Usage
 * ### Basic mysql blueprint
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Database;
 * import com.pulumi.aws.lightsail.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Database("test", DatabaseArgs.builder()
 *             .availabilityZone("us-east-1a")
 *             .blueprintId("mysql_8_0")
 *             .bundleId("micro_1_0")
 *             .masterDatabaseName("testdatabasename")
 *             .masterPassword("testdatabasepassword")
 *             .masterUsername("test")
 *             .relationalDatabaseName("test")
 *             .build());
 *     }
 * }
 * ```
 * ### Basic postrgres blueprint
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Database;
 * import com.pulumi.aws.lightsail.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Database("test", DatabaseArgs.builder()
 *             .availabilityZone("us-east-1a")
 *             .blueprintId("postgres_12")
 *             .bundleId("micro_1_0")
 *             .masterDatabaseName("testdatabasename")
 *             .masterPassword("testdatabasepassword")
 *             .masterUsername("test")
 *             .relationalDatabaseName("test")
 *             .build());
 *     }
 * }
 * ```
 * ### Custom backup and maintenance windows
 * Below is an example that sets a custom backup and maintenance window. Times are specified in UTC. This example will allow daily backups to take place between 16:00 and 16:30 each day. This example also requires any maintiance tasks (anything that would cause an outage, including changing some attributes) to take place on Tuesdays between 17:00 and 17:30. An action taken against this database that would cause an outage will wait until this time window to make the requested changes.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Database;
 * import com.pulumi.aws.lightsail.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Database("test", DatabaseArgs.builder()
 *             .availabilityZone("us-east-1a")
 *             .blueprintId("postgres_12")
 *             .bundleId("micro_1_0")
 *             .masterDatabaseName("testdatabasename")
 *             .masterPassword("testdatabasepassword")
 *             .masterUsername("test")
 *             .preferredBackupWindow("16:00-16:30")
 *             .preferredMaintenanceWindow("Tue:17:00-Tue:17:30")
 *             .relationalDatabaseName("test")
 *             .build());
 *     }
 * }
 * ```
 * ### Final Snapshots
 * To enable creating a final snapshot of your database on deletion, use the `final_snapshot_name` argument to provide a name to be used for the snapshot.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Database;
 * import com.pulumi.aws.lightsail.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Database("test", DatabaseArgs.builder()
 *             .availabilityZone("us-east-1a")
 *             .blueprintId("postgres_12")
 *             .bundleId("micro_1_0")
 *             .finalSnapshotName("MyFinalSnapshot")
 *             .masterDatabaseName("testdatabasename")
 *             .masterPassword("testdatabasepassword")
 *             .masterUsername("test")
 *             .preferredBackupWindow("16:00-16:30")
 *             .preferredMaintenanceWindow("Tue:17:00-Tue:17:30")
 *             .relationalDatabaseName("test")
 *             .build());
 *     }
 * }
 * ```
 * ### Apply Immediately
 * To enable applying changes immediately instead of waiting for a maintiance window, use the `apply_immediately` argument.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Database;
 * import com.pulumi.aws.lightsail.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Database("test", DatabaseArgs.builder()
 *             .applyImmediately(true)
 *             .availabilityZone("us-east-1a")
 *             .blueprintId("postgres_12")
 *             .bundleId("micro_1_0")
 *             .masterDatabaseName("testdatabasename")
 *             .masterPassword("testdatabasepassword")
 *             .masterUsername("test")
 *             .relationalDatabaseName("test")
 *             .build());
 *     }
 * }
 * ```
 * ## Blueprint Ids
 * A list of all available Lightsail Blueprints for Relational Databases the [aws lightsail get-relational-database-blueprints](https://docs.aws.amazon.com/cli/latest/reference/lightsail/get-relational-database-blueprints.html) aws cli command.
 * ### Examples
 * - `mysql_8_0`
 * - `postgres_12`
 * ### Prefix
 * A Blueprint ID starts with a prefix of the engine type.
 * ### Suffix
 * A Blueprint ID has a sufix of the engine version.
 * ## Bundles
 * A list of all available Lightsail Bundles for Relational Databases the [aws lightsail get-relational-database-bundles](https://docs.aws.amazon.com/cli/latest/reference/lightsail/get-relational-database-bundles.html) aws cli command.
 * ### Examples
 * - `small_1_0`
 * - `small_ha_1_0`
 * - `large_1_0`
 * - `large_ha_1_0`
 * ### Prefix
 * A Bundle ID starts with one of the below size prefixes:
 * - `micro_`
 * - `small_`
 * - `medium_`
 * - `large_`
 * ### Infixes (Optional for HA Database)
 * A Bundle Id can have the following infix added in order to use the HA option of the selected bundle.
 * - `ha_`
 * ### Suffix
 * A Bundle ID ends with one of the following suffix: `1_0`
 * ## Import
 * Using `pulumi import`, import Lightsail Databases using their name. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/database:Database foo 'bar'
 * ```
 *
 */
public class Database internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.Database,
) : KotlinCustomResource(javaResource, DatabaseMapper) {
    /**
     * When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
     */
    public val applyImmediately: Output<Boolean>
        get() = javaResource.applyImmediately().applyValue({ args0 -> args0 })

    /**
     * The ARN of the Lightsail instance (matches `id`).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
     */
    public val backupRetentionEnabled: Output<Boolean>?
        get() = javaResource.backupRetentionEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
     */
    public val blueprintId: Output<String>
        get() = javaResource.blueprintId().applyValue({ args0 -> args0 })

    /**
     * The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
     */
    public val bundleId: Output<String>
        get() = javaResource.bundleId().applyValue({ args0 -> args0 })

    /**
     * The certificate associated with the database.
     */
    public val caCertificateIdentifier: Output<String>
        get() = javaResource.caCertificateIdentifier().applyValue({ args0 -> args0 })

    /**
     * The number of vCPUs for the database.
     */
    public val cpuCount: Output<Int>
        get() = javaResource.cpuCount().applyValue({ args0 -> args0 })

    /**
     * The timestamp when the instance was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The size of the disk for the database.
     */
    public val diskSize: Output<Double>
        get() = javaResource.diskSize().applyValue({ args0 -> args0 })

    /**
     * The database software (for example, MySQL).
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * The database engine version (for example, 5.7.23).
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
     */
    public val finalSnapshotName: Output<String>?
        get() = javaResource.finalSnapshotName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the master database created when the Lightsail database resource is created.
     */
    public val masterDatabaseName: Output<String>
        get() = javaResource.masterDatabaseName().applyValue({ args0 -> args0 })

    /**
     * The master endpoint fqdn for the database.
     */
    public val masterEndpointAddress: Output<String>
        get() = javaResource.masterEndpointAddress().applyValue({ args0 -> args0 })

    /**
     * The master endpoint network port for the database.
     */
    public val masterEndpointPort: Output<Int>
        get() = javaResource.masterEndpointPort().applyValue({ args0 -> args0 })

    /**
     * The password for the master user of your new database. The password can include any printable ASCII character except "/", """, or "@".
     */
    public val masterPassword: Output<String>
        get() = javaResource.masterPassword().applyValue({ args0 -> args0 })

    /**
     * The master user name for your new database.
     */
    public val masterUsername: Output<String>
        get() = javaResource.masterUsername().applyValue({ args0 -> args0 })

    /**
     * The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
     */
    public val preferredBackupWindow: Output<String>
        get() = javaResource.preferredBackupWindow().applyValue({ args0 -> args0 })

    /**
     * The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
     */
    public val preferredMaintenanceWindow: Output<String>
        get() = javaResource.preferredMaintenanceWindow().applyValue({ args0 -> args0 })

    /**
     * Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
     */
    public val publiclyAccessible: Output<Boolean>?
        get() = javaResource.publiclyAccessible().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The amount of RAM in GB for the database.
     */
    public val ramSize: Output<Double>
        get() = javaResource.ramSize().applyValue({ args0 -> args0 })

    /**
     * The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
     */
    public val relationalDatabaseName: Output<String>
        get() = javaResource.relationalDatabaseName().applyValue({ args0 -> args0 })

    /**
     * Describes the secondary Availability Zone of a high availability database. The secondary database is used for failover support of a high availability database.
     */
    public val secondaryAvailabilityZone: Output<String>
        get() = javaResource.secondaryAvailabilityZone().applyValue({ args0 -> args0 })

    /**
     * Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
     */
    public val skipFinalSnapshot: Output<Boolean>?
        get() = javaResource.skipFinalSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The support code for the database. Include this code in your email to support when you have questions about a database in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: Output<String>
        get() = javaResource.supportCode().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DatabaseMapper : ResourceMapper<Database> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.Database::class == javaResource::class

    override fun map(javaResource: Resource): Database = Database(
        javaResource as
            com.pulumi.aws.lightsail.Database,
    )
}

/**
 * @see [Database].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Database].
 */
public suspend fun database(name: String, block: suspend DatabaseResourceBuilder.() -> Unit):
    Database {
    val builder = DatabaseResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Database].
 * @param name The _unique_ name of the resulting resource.
 */
public fun database(name: String): Database {
    val builder = DatabaseResourceBuilder()
    builder.name(name)
    return builder.build()
}
