@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.aws.lightsail.DatabaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Lightsail Database. Amazon Lightsail is a service to provide easy virtual private servers
 * with custom software already setup. See [What is Amazon Lightsail?](https://lightsail.aws.amazon.com/ls/docs/getting-started/article/what-is-amazon-lightsail)
 * for more information.
 * > **Note:** Lightsail is currently only supported in a limited number of AWS Regions, please see ["Regions and Availability Zones"](https://aws.amazon.com/about-aws/global-infrastructure/regional-product-services/) for more details
 * ## Example Usage
 * ### Basic mysql blueprint
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Database;
 * import com.pulumi.aws.lightsail.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Database("test", DatabaseArgs.builder()
 *             .availabilityZone("us-east-1a")
 *             .blueprintId("mysql_8_0")
 *             .bundleId("micro_1_0")
 *             .masterDatabaseName("testdatabasename")
 *             .masterPassword("testdatabasepassword")
 *             .masterUsername("test")
 *             .relationalDatabaseName("test")
 *             .build());
 *     }
 * }
 * ```
 * ### Basic postrgres blueprint
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Database;
 * import com.pulumi.aws.lightsail.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Database("test", DatabaseArgs.builder()
 *             .availabilityZone("us-east-1a")
 *             .blueprintId("postgres_12")
 *             .bundleId("micro_1_0")
 *             .masterDatabaseName("testdatabasename")
 *             .masterPassword("testdatabasepassword")
 *             .masterUsername("test")
 *             .relationalDatabaseName("test")
 *             .build());
 *     }
 * }
 * ```
 * ### Custom backup and maintenance windows
 * Below is an example that sets a custom backup and maintenance window. Times are specified in UTC. This example will allow daily backups to take place between 16:00 and 16:30 each day. This example also requires any maintiance tasks (anything that would cause an outage, including changing some attributes) to take place on Tuesdays between 17:00 and 17:30. An action taken against this database that would cause an outage will wait until this time window to make the requested changes.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Database;
 * import com.pulumi.aws.lightsail.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Database("test", DatabaseArgs.builder()
 *             .availabilityZone("us-east-1a")
 *             .blueprintId("postgres_12")
 *             .bundleId("micro_1_0")
 *             .masterDatabaseName("testdatabasename")
 *             .masterPassword("testdatabasepassword")
 *             .masterUsername("test")
 *             .preferredBackupWindow("16:00-16:30")
 *             .preferredMaintenanceWindow("Tue:17:00-Tue:17:30")
 *             .relationalDatabaseName("test")
 *             .build());
 *     }
 * }
 * ```
 * ### Final Snapshots
 * To enable creating a final snapshot of your database on deletion, use the `final_snapshot_name` argument to provide a name to be used for the snapshot.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Database;
 * import com.pulumi.aws.lightsail.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Database("test", DatabaseArgs.builder()
 *             .availabilityZone("us-east-1a")
 *             .blueprintId("postgres_12")
 *             .bundleId("micro_1_0")
 *             .finalSnapshotName("MyFinalSnapshot")
 *             .masterDatabaseName("testdatabasename")
 *             .masterPassword("testdatabasepassword")
 *             .masterUsername("test")
 *             .preferredBackupWindow("16:00-16:30")
 *             .preferredMaintenanceWindow("Tue:17:00-Tue:17:30")
 *             .relationalDatabaseName("test")
 *             .build());
 *     }
 * }
 * ```
 * ### Apply Immediately
 * To enable applying changes immediately instead of waiting for a maintiance window, use the `apply_immediately` argument.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.lightsail.Database;
 * import com.pulumi.aws.lightsail.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Database("test", DatabaseArgs.builder()
 *             .applyImmediately(true)
 *             .availabilityZone("us-east-1a")
 *             .blueprintId("postgres_12")
 *             .bundleId("micro_1_0")
 *             .masterDatabaseName("testdatabasename")
 *             .masterPassword("testdatabasepassword")
 *             .masterUsername("test")
 *             .relationalDatabaseName("test")
 *             .build());
 *     }
 * }
 * ```
 * ## Blueprint Ids
 * A list of all available Lightsail Blueprints for Relational Databases the [aws lightsail get-relational-database-blueprints](https://docs.aws.amazon.com/cli/latest/reference/lightsail/get-relational-database-blueprints.html) aws cli command.
 * ### Examples
 * - `mysql_8_0`
 * - `postgres_12`
 * ### Prefix
 * A Blueprint ID starts with a prefix of the engine type.
 * ### Suffix
 * A Blueprint ID has a sufix of the engine version.
 * ## Bundles
 * A list of all available Lightsail Bundles for Relational Databases the [aws lightsail get-relational-database-bundles](https://docs.aws.amazon.com/cli/latest/reference/lightsail/get-relational-database-bundles.html) aws cli command.
 * ### Examples
 * - `small_1_0`
 * - `small_ha_1_0`
 * - `large_1_0`
 * - `large_ha_1_0`
 * ### Prefix
 * A Bundle ID starts with one of the below size prefixes:
 * - `micro_`
 * - `small_`
 * - `medium_`
 * - `large_`
 * ### Infixes (Optional for HA Database)
 * A Bundle Id can have the following infix added in order to use the HA option of the selected bundle.
 * - `ha_`
 * ### Suffix
 * A Bundle ID ends with one of the following suffix: `1_0`
 * ## Import
 * Using `pulumi import`, import Lightsail Databases using their name. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/database:Database foo 'bar'
 * ```
 * @property applyImmediately When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
 * @property availabilityZone The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
 * @property backupRetentionEnabled When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
 * @property blueprintId The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
 * @property bundleId The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
 * @property finalSnapshotName The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
 * @property masterDatabaseName The name of the master database created when the Lightsail database resource is created.
 * @property masterPassword The password for the master user of your new database. The password can include any printable ASCII character except "/", """, or "@".
 * @property masterUsername The master user name for your new database.
 * @property preferredBackupWindow The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
 * @property preferredMaintenanceWindow The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
 * @property publiclyAccessible Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
 * @property relationalDatabaseName The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
 * @property skipFinalSnapshot Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
 * @property tags A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
 */
public data class DatabaseArgs(
    public val applyImmediately: Output<Boolean>? = null,
    public val availabilityZone: Output<String>? = null,
    public val backupRetentionEnabled: Output<Boolean>? = null,
    public val blueprintId: Output<String>? = null,
    public val bundleId: Output<String>? = null,
    public val finalSnapshotName: Output<String>? = null,
    public val masterDatabaseName: Output<String>? = null,
    public val masterPassword: Output<String>? = null,
    public val masterUsername: Output<String>? = null,
    public val preferredBackupWindow: Output<String>? = null,
    public val preferredMaintenanceWindow: Output<String>? = null,
    public val publiclyAccessible: Output<Boolean>? = null,
    public val relationalDatabaseName: Output<String>? = null,
    public val skipFinalSnapshot: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lightsail.DatabaseArgs> {
    override fun toJava(): com.pulumi.aws.lightsail.DatabaseArgs =
        com.pulumi.aws.lightsail.DatabaseArgs.builder()
            .applyImmediately(applyImmediately?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .backupRetentionEnabled(backupRetentionEnabled?.applyValue({ args0 -> args0 }))
            .blueprintId(blueprintId?.applyValue({ args0 -> args0 }))
            .bundleId(bundleId?.applyValue({ args0 -> args0 }))
            .finalSnapshotName(finalSnapshotName?.applyValue({ args0 -> args0 }))
            .masterDatabaseName(masterDatabaseName?.applyValue({ args0 -> args0 }))
            .masterPassword(masterPassword?.applyValue({ args0 -> args0 }))
            .masterUsername(masterUsername?.applyValue({ args0 -> args0 }))
            .preferredBackupWindow(preferredBackupWindow?.applyValue({ args0 -> args0 }))
            .preferredMaintenanceWindow(preferredMaintenanceWindow?.applyValue({ args0 -> args0 }))
            .publiclyAccessible(publiclyAccessible?.applyValue({ args0 -> args0 }))
            .relationalDatabaseName(relationalDatabaseName?.applyValue({ args0 -> args0 }))
            .skipFinalSnapshot(skipFinalSnapshot?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DatabaseArgs].
 */
@PulumiTagMarker
public class DatabaseArgsBuilder internal constructor() {
    private var applyImmediately: Output<Boolean>? = null

    private var availabilityZone: Output<String>? = null

    private var backupRetentionEnabled: Output<Boolean>? = null

    private var blueprintId: Output<String>? = null

    private var bundleId: Output<String>? = null

    private var finalSnapshotName: Output<String>? = null

    private var masterDatabaseName: Output<String>? = null

    private var masterPassword: Output<String>? = null

    private var masterUsername: Output<String>? = null

    private var preferredBackupWindow: Output<String>? = null

    private var preferredMaintenanceWindow: Output<String>? = null

    private var publiclyAccessible: Output<Boolean>? = null

    private var relationalDatabaseName: Output<String>? = null

    private var skipFinalSnapshot: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
     */
    @JvmName("aessjnbxwcaxjaop")
    public suspend fun applyImmediately(`value`: Output<Boolean>) {
        this.applyImmediately = value
    }

    /**
     * @param value The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
     */
    @JvmName("vgsefvarntnwugme")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
     */
    @JvmName("uoclmaindaewtqwf")
    public suspend fun backupRetentionEnabled(`value`: Output<Boolean>) {
        this.backupRetentionEnabled = value
    }

    /**
     * @param value The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
     */
    @JvmName("bjtwhjabqxktdkkf")
    public suspend fun blueprintId(`value`: Output<String>) {
        this.blueprintId = value
    }

    /**
     * @param value The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
     */
    @JvmName("jychejfjcrbgqgtv")
    public suspend fun bundleId(`value`: Output<String>) {
        this.bundleId = value
    }

    /**
     * @param value The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
     */
    @JvmName("ptrchmyktprilkcv")
    public suspend fun finalSnapshotName(`value`: Output<String>) {
        this.finalSnapshotName = value
    }

    /**
     * @param value The name of the master database created when the Lightsail database resource is created.
     */
    @JvmName("uhkdohkefsncbpuj")
    public suspend fun masterDatabaseName(`value`: Output<String>) {
        this.masterDatabaseName = value
    }

    /**
     * @param value The password for the master user of your new database. The password can include any printable ASCII character except "/", """, or "@".
     */
    @JvmName("fltskgvdosuykpyt")
    public suspend fun masterPassword(`value`: Output<String>) {
        this.masterPassword = value
    }

    /**
     * @param value The master user name for your new database.
     */
    @JvmName("mbcyaxrvuserpucg")
    public suspend fun masterUsername(`value`: Output<String>) {
        this.masterUsername = value
    }

    /**
     * @param value The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
     */
    @JvmName("ujbjwaxnspfwddsj")
    public suspend fun preferredBackupWindow(`value`: Output<String>) {
        this.preferredBackupWindow = value
    }

    /**
     * @param value The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
     */
    @JvmName("axpieeqvxulwmbpo")
    public suspend fun preferredMaintenanceWindow(`value`: Output<String>) {
        this.preferredMaintenanceWindow = value
    }

    /**
     * @param value Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
     */
    @JvmName("outhmwhnigvkrong")
    public suspend fun publiclyAccessible(`value`: Output<Boolean>) {
        this.publiclyAccessible = value
    }

    /**
     * @param value The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
     */
    @JvmName("rfqhexhbqtjbbcps")
    public suspend fun relationalDatabaseName(`value`: Output<String>) {
        this.relationalDatabaseName = value
    }

    /**
     * @param value Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
     */
    @JvmName("hjcormuaumngdrey")
    public suspend fun skipFinalSnapshot(`value`: Output<Boolean>) {
        this.skipFinalSnapshot = value
    }

    /**
     * @param value A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
     */
    @JvmName("mywkdvochfawbkxv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value When true , applies changes immediately. When false , applies changes during the preferred maintenance window. Some changes may cause an outage.
     */
    @JvmName("fbcipwnjyagsebib")
    public suspend fun applyImmediately(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyImmediately = mapped
    }

    /**
     * @param value The Availability Zone in which to create your new database. Use the us-east-2a case-sensitive format.
     */
    @JvmName("jdmuqdxivliescoj")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value When true, enables automated backup retention for your database. When false, disables automated backup retention for your database. Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database.
     */
    @JvmName("ogmijrilhknbrwlb")
    public suspend fun backupRetentionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupRetentionEnabled = mapped
    }

    /**
     * @param value The blueprint ID for your new database. A blueprint describes the major engine version of a database. You can get a list of database blueprints IDs by using the AWS CLI command: `aws lightsail get-relational-database-blueprints`
     */
    @JvmName("acqkwxochcppxdug")
    public suspend fun blueprintId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blueprintId = mapped
    }

    /**
     * @param value The bundle ID for your new database. A bundle describes the performance specifications for your database (see list below). You can get a list of database bundle IDs by using the AWS CLI command: `aws lightsail get-relational-database-bundles`.
     */
    @JvmName("bfkxruqdmkrwuoow")
    public suspend fun bundleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bundleId = mapped
    }

    /**
     * @param value The name of the database snapshot created if skip final snapshot is false, which is the default value for that parameter.
     */
    @JvmName("pwobvyytfpuxwrjn")
    public suspend fun finalSnapshotName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.finalSnapshotName = mapped
    }

    /**
     * @param value The name of the master database created when the Lightsail database resource is created.
     */
    @JvmName("jdafjogqdjfisxti")
    public suspend fun masterDatabaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterDatabaseName = mapped
    }

    /**
     * @param value The password for the master user of your new database. The password can include any printable ASCII character except "/", """, or "@".
     */
    @JvmName("jfprhsghrulcxwra")
    public suspend fun masterPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterPassword = mapped
    }

    /**
     * @param value The master user name for your new database.
     */
    @JvmName("hcbfvbmhmuawmofn")
    public suspend fun masterUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterUsername = mapped
    }

    /**
     * @param value The daily time range during which automated backups are created for your new database if automated backups are enabled. Must be in the hh24:mi-hh24:mi format. Example: `16:00-16:30`. Specified in Coordinated Universal Time (UTC).
     */
    @JvmName("ickvweqfjnioitik")
    public suspend fun preferredBackupWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredBackupWindow = mapped
    }

    /**
     * @param value The weekly time range during which system maintenance can occur on your new database. Must be in the ddd:hh24:mi-ddd:hh24:mi format. Specified in Coordinated Universal Time (UTC). Example: `Tue:17:00-Tue:17:30`
     */
    @JvmName("ptdfubgjmmytuibf")
    public suspend fun preferredMaintenanceWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredMaintenanceWindow = mapped
    }

    /**
     * @param value Specifies the accessibility options for your new database. A value of true specifies a database that is available to resources outside of your Lightsail account. A value of false specifies a database that is available only to your Lightsail resources in the same region as your database.
     */
    @JvmName("ocpuwdsfyyqhofoj")
    public suspend fun publiclyAccessible(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publiclyAccessible = mapped
    }

    /**
     * @param value The name to use for your new Lightsail database resource. Names be unique within each AWS Region in your Lightsail account.
     */
    @JvmName("cswvqoqnppqtdkrv")
    public suspend fun relationalDatabaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relationalDatabaseName = mapped
    }

    /**
     * @param value Determines whether a final database snapshot is created before your database is deleted. If true is specified, no database snapshot is created. If false is specified, a database snapshot is created before your database is deleted. You must specify the final relational database snapshot name parameter if the skip final snapshot parameter is false.
     */
    @JvmName("sodqoegbuadduhdo")
    public suspend fun skipFinalSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipFinalSnapshot = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
     */
    @JvmName("yhyybwecfhlurldn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value.
     */
    @JvmName("qmssgtuogoyskcyq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DatabaseArgs = DatabaseArgs(
        applyImmediately = applyImmediately,
        availabilityZone = availabilityZone,
        backupRetentionEnabled = backupRetentionEnabled,
        blueprintId = blueprintId,
        bundleId = bundleId,
        finalSnapshotName = finalSnapshotName,
        masterDatabaseName = masterDatabaseName,
        masterPassword = masterPassword,
        masterUsername = masterUsername,
        preferredBackupWindow = preferredBackupWindow,
        preferredMaintenanceWindow = preferredMaintenanceWindow,
        publiclyAccessible = publiclyAccessible,
        relationalDatabaseName = relationalDatabaseName,
        skipFinalSnapshot = skipFinalSnapshot,
        tags = tags,
    )
}
