@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lightsail.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Disk].
 */
@PulumiTagMarker
public class DiskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiskArgs = DiskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiskArgsBuilder.() -> Unit) {
        val builder = DiskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Disk {
        val builtJavaResource = com.pulumi.aws.lightsail.Disk(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Disk(builtJavaResource)
    }
}

/**
 * Provides a Lightsail Disk resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.lightsail.Disk;
 * import com.pulumi.aws.lightsail.DiskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .filters(GetAvailabilityZonesFilterArgs.builder()
 *                 .name("opt-in-status")
 *                 .values("opt-in-not-required")
 *                 .build())
 *             .build());
 *         var test = new Disk("test", DiskArgs.builder()
 *             .sizeInGb(8)
 *             .availabilityZone(available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_lightsail_disk` using the name attribute. For example:
 * ```sh
 *  $ pulumi import aws:lightsail/disk:Disk test test
 * ```
 *
 */
public class Disk internal constructor(
    override val javaResource: com.pulumi.aws.lightsail.Disk,
) : KotlinCustomResource(javaResource, DiskMapper) {
    /**
     * The ARN of the Lightsail load balancer.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Availability Zone in which to create your disk.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The timestamp when the load balancer was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The name of the Lightsail load balancer.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The instance port the load balancer will connect.
     */
    public val sizeInGb: Output<Int>
        get() = javaResource.sizeInGb().applyValue({ args0 -> args0 })

    /**
     * The support code for the disk. Include this code in your email to support when you have questions about a disk in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: Output<String>
        get() = javaResource.supportCode().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. To create a key-only tag, use an empty string as the value. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DiskMapper : ResourceMapper<Disk> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.lightsail.Disk::class == javaResource::class

    override fun map(javaResource: Resource): Disk = Disk(
        javaResource as
            com.pulumi.aws.lightsail.Disk,
    )
}

/**
 * @see [Disk].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Disk].
 */
public suspend fun disk(name: String, block: suspend DiskResourceBuilder.() -> Unit): Disk {
    val builder = DiskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Disk].
 * @param name The _unique_ name of the resulting resource.
 */
public fun disk(name: String): Disk {
    val builder = DiskResourceBuilder()
    builder.name(name)
    return builder.build()
}
